/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.parser.AppointmentParser;
import com.openexchange.ajax.writer.AppointmentWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.java.Charsets;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConflictTest
extends AppointmentTest {
    private static final Log LOG = LogFactory.getLog(ConflictTest.class);

    public ConflictTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Calendar c = Calendar.getInstance();
        c.setTimeZone(this.timeZone);
        c.set(11, 8);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        startTime = c.getTimeInMillis();
        startTime += (long)this.timeZone.getOffset(startTime);
        endTime = startTime + 0x6DDD00L;
    }

    public void testConflict1() throws Exception {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTimeInMillis(startTime);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date rangeStart = calendar.getTime();
        calendar.add(5, 1);
        Date rangeEnd = calendar.getTime();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testConflict1 - insert");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        Appointment[] appointmentConflicts = ConflictTest.insertAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ConflictTest.assertNotNull((String)"conflicts expected!", (Object)appointmentConflicts);
        boolean found = false;
        for (int a = 0; a < appointmentConflicts.length; ++a) {
            if (appointmentConflicts[a].getObjectID() != objectId) continue;
            found = true;
        }
        ConflictTest.assertTrue((String)("appointment id " + objectId + " not found in conflicts"), (boolean)found);
        appointmentObj.setIgnoreConflicts(true);
        int secondObjectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Appointment loadAppointment = ConflictTest.loadAppointment(this.getWebConversation(), secondObjectId, appointmentFolderId, rangeStart, rangeEnd, APPOINTMENT_FIELDS, this.timeZone, this.getHostName(), this.getSessionId());
        Date modified = loadAppointment.getCreationDate();
        appointmentObj.setObjectID(secondObjectId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setShownAs(4);
        ConflictTest.updateAppointment(this.getWebConversation(), appointmentObj, secondObjectId, appointmentFolderId, modified, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        loadAppointment = ConflictTest.loadAppointment(this.getWebConversation(), secondObjectId, appointmentFolderId, rangeStart, rangeEnd, APPOINTMENT_FIELDS, this.timeZone, this.getHostName(), this.getSessionId());
        modified = loadAppointment.getLastModified();
        appointmentObj.setIgnoreConflicts(false);
        appointmentObj.setShownAs(3);
        appointmentObj.setTitle("testConflict1 - update");
        appointmentConflicts = ConflictTest.updateAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, secondObjectId, appointmentFolderId, modified, this.timeZone, this.getHostName(), this.getSessionId());
        ConflictTest.assertNotNull((String)"conflicts expected!", (Object)appointmentConflicts);
        found = false;
        for (int a = 0; a < appointmentConflicts.length; ++a) {
            if (appointmentConflicts[a].getObjectID() != objectId) continue;
            found = true;
        }
        ConflictTest.assertTrue((String)("appointment id " + objectId + " not found in conflicts"), (boolean)found);
        ConflictTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, modified, "http://" + this.getHostName(), this.getSessionId(), false);
        ConflictTest.deleteAppointment(this.getWebConversation(), secondObjectId, appointmentFolderId, modified, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testConflict2() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testConflict2");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        appointmentObj.setEndDate(new Date(endTime - 3600000L));
        Appointment[] appointmentConflicts = ConflictTest.insertAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ConflictTest.assertNotNull((String)"conflicts expected!", (Object)appointmentConflicts);
        boolean found = false;
        for (int a = 0; a < appointmentConflicts.length; ++a) {
            if (appointmentConflicts[a].getObjectID() != objectId) continue;
            found = true;
        }
        ConflictTest.assertTrue((String)("appointment id " + objectId + " not found in conflicts"), (boolean)found);
        ConflictTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testConflict3() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testConflict3");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        appointmentObj.setEndDate(new Date(endTime + 3600000L));
        Appointment[] appointmentConflicts = ConflictTest.insertAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ConflictTest.assertNotNull((String)"conflicts expected!", (Object)appointmentConflicts);
        boolean found = false;
        for (int a = 0; a < appointmentConflicts.length; ++a) {
            if (appointmentConflicts[a].getObjectID() != objectId) continue;
            found = true;
        }
        ConflictTest.assertTrue((String)("appointment id " + objectId + " not found in conflicts"), (boolean)found);
        ConflictTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testConflict4() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testConflict4");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        appointmentObj.setStartDate(new Date(startTime - 3600000L));
        Appointment[] appointmentConflicts = ConflictTest.insertAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ConflictTest.assertNotNull((String)"conflicts expected!", (Object)appointmentConflicts);
        boolean found = false;
        for (int a = 0; a < appointmentConflicts.length; ++a) {
            if (appointmentConflicts[a].getObjectID() != objectId) continue;
            found = true;
        }
        ConflictTest.assertTrue((String)("appointment id " + objectId + " not found in conflicts"), (boolean)found);
        ConflictTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testConflict5() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testConflict5");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        appointmentObj.setStartDate(new Date(startTime + 3600000L));
        Appointment[] appointmentConflicts = ConflictTest.insertAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ConflictTest.assertNotNull((String)"conflicts expected!", (Object)appointmentConflicts);
        boolean found = false;
        for (int a = 0; a < appointmentConflicts.length; ++a) {
            if (appointmentConflicts[a].getObjectID() != objectId) continue;
            found = true;
        }
        ConflictTest.assertTrue((String)("appointment id " + objectId + " not found in conflicts"), (boolean)found);
        ConflictTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testConflict6() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testConflict6");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        appointmentObj.setStartDate(new Date(startTime + 3600000L));
        appointmentObj.setEndDate(new Date(endTime - 1800000L));
        Appointment[] appointmentConflicts = ConflictTest.insertAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ConflictTest.assertNotNull((String)"conflicts expected!", (Object)appointmentConflicts);
        boolean found = false;
        for (int a = 0; a < appointmentConflicts.length; ++a) {
            if (appointmentConflicts[a].getObjectID() != objectId) continue;
            found = true;
        }
        ConflictTest.assertTrue((String)("appointment id " + objectId + " not found in conflicts"), (boolean)found);
        ConflictTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testConflict7() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testConflict7");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        appointmentObj.setStartDate(new Date(startTime - 3600000L));
        appointmentObj.setEndDate(new Date(endTime + 3600000L));
        Appointment[] appointmentConflicts = ConflictTest.insertAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ConflictTest.assertNotNull((String)"conflicts expected!", (Object)appointmentConflicts);
        boolean found = false;
        for (int a = 0; a < appointmentConflicts.length; ++a) {
            if (appointmentConflicts[a].getObjectID() != objectId) continue;
            found = true;
        }
        ConflictTest.assertTrue((String)("appointment id " + objectId + " not found in conflicts"), (boolean)found);
        ConflictTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testNonConflict1() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testNonConflict1");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        appointmentObj.setStartDate(new Date(startTime - 3600000L));
        appointmentObj.setEndDate(new Date(endTime - 0x6DDD00L));
        Appointment[] appointmentConflicts = ConflictTest.insertAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        boolean found = false;
        if (appointmentConflicts != null) {
            for (int a = 0; a < appointmentConflicts.length; ++a) {
                if (appointmentConflicts[a].getObjectID() != objectId) continue;
                found = true;
            }
        }
        ConflictTest.assertFalse((String)("appointment id " + objectId + " found in conflicts"), (boolean)found);
        ConflictTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testNonConflict2() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testNonConflict2");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        appointmentObj.setStartDate(new Date(startTime + 0x6DDD00L));
        appointmentObj.setEndDate(new Date(endTime + 3600000L));
        Appointment[] appointmentConflicts = ConflictTest.insertAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        boolean found = false;
        if (appointmentConflicts != null) {
            for (int a = 0; a < appointmentConflicts.length; ++a) {
                if (appointmentConflicts[a].getObjectID() != objectId) continue;
                found = true;
            }
        }
        ConflictTest.assertFalse((String)("appointment id " + objectId + " found in conflicts"), (boolean)found);
        ConflictTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testFullTimeConflict1() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testFullTimeConflict1");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setFullTime(true);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        Appointment[] appointmentConflicts = ConflictTest.insertAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ConflictTest.assertNotNull((String)"conflicts expected!", (Object)appointmentConflicts);
        boolean found = false;
        for (int a = 0; a < appointmentConflicts.length; ++a) {
            if (appointmentConflicts[a].getObjectID() != objectId) continue;
            found = true;
        }
        ConflictTest.assertTrue((String)("appointment id " + objectId + " not found in conflicts"), (boolean)found);
        ConflictTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testFullTimeConflict2() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testFullTimeConflict2");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setFullTime(true);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ConflictTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        Appointment[] appointmentConflicts = ConflictTest.insertAppointmentReturnConflicts(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ConflictTest.assertNotNull((String)"conflicts expected!", (Object)appointmentConflicts);
        boolean found = false;
        for (int a = 0; a < appointmentConflicts.length; ++a) {
            if (appointmentConflicts[a].getObjectID() != objectId) continue;
            found = true;
        }
        ConflictTest.assertTrue((String)("appointment id " + objectId + " not found in conflicts"), (boolean)found);
        ConflictTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public static Appointment[] insertAppointmentReturnConflicts(WebConversation webCon, Appointment appointmentObj, TimeZone userTimeZone, String host, String session) throws Exception, OXException {
        JSONObject data;
        host = ConflictTest.appendPrefix(host);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        JSONObject jsonObj = new JSONObject();
        AppointmentWriter appointmentwriter = new AppointmentWriter(userTimeZone);
        appointmentwriter.writeAppointment(appointmentObj, jsonObj);
        pw.print(jsonObj.toString());
        pw.flush();
        baos.toByteArray();
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "new");
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + "/ajax/calendar" + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ConflictTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            ConflictTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        if ((data = (JSONObject)response.getData()).has("id")) {
            data.getInt("id");
        }
        if (data.has("conflicts")) {
            AppointmentParser appointmentParser = new AppointmentParser(userTimeZone);
            JSONArray jsonArray = data.getJSONArray("conflicts");
            Appointment[] appointmentArray = new Appointment[jsonArray.length()];
            for (int a = 0; a < jsonArray.length(); ++a) {
                appointmentArray[a] = new Appointment();
                appointmentParser.parse(appointmentArray[a], jsonArray.getJSONObject(a));
            }
            return appointmentArray;
        }
        return null;
    }

    public static Appointment[] updateAppointmentReturnConflicts(WebConversation webCon, Appointment appointmentObj, int objectId, int inFolder, Date modified, TimeZone userTimeZone, String host, String session) throws Exception, OXException {
        JSONObject data;
        host = ConflictTest.appendPrefix(host);
        StringWriter stringWriter = new StringWriter();
        JSONObject jsonObj = new JSONObject();
        AppointmentWriter appointmentwriter = new AppointmentWriter(userTimeZone);
        appointmentwriter.writeAppointment(appointmentObj, jsonObj);
        stringWriter.write(jsonObj.toString());
        stringWriter.flush();
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "update");
        parameter.setParameter("id", String.valueOf(objectId));
        parameter.setParameter("folder", String.valueOf(inFolder));
        parameter.setParameter("timestamp", modified);
        ByteArrayInputStream bais = new ByteArrayInputStream(stringWriter.toString().getBytes(Charsets.UTF_8));
        PutMethodWebRequest req = new PutMethodWebRequest(host + "/ajax/calendar" + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ConflictTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            ConflictTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        if ((data = (JSONObject)response.getData()).has("id")) {
            objectId = data.getInt("id");
        }
        if (data.has("conflicts")) {
            AppointmentParser appointmentParser = new AppointmentParser(userTimeZone);
            JSONArray jsonArray = data.getJSONArray("conflicts");
            Appointment[] appointmentArray = new Appointment[jsonArray.length()];
            for (int a = 0; a < jsonArray.length(); ++a) {
                appointmentArray[a] = new Appointment();
                appointmentParser.parse(appointmentArray[a], jsonArray.getJSONObject(a));
            }
            return appointmentArray;
        }
        return null;
    }
}

