/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ConnectQuotaExceededException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.util.MailLogger;
import com.sun.mail.util.PropUtil;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.mail.URLName;

public class JavaIMAPProtocol
extends IMAPProtocol {
    private static final ConcurrentMap<URLName, Semaphore> semaphores = new ConcurrentHashMap<URLName, Semaphore>(16);
    private final int maxNumAuthenticated;
    private volatile Semaphore semaphore;
    private final long authTimeoutMillis;
    private final int accountId;
    private final AtomicInteger permitCount = new AtomicInteger();

    private static Semaphore initAuthSemaphore(URLName url, int permits, MailLogger logger) {
        Semaphore ns;
        if (permits <= 0) {
            return null;
        }
        Semaphore s = (Semaphore)semaphores.get(url);
        if (null == s && null == (s = semaphores.putIfAbsent(url, ns = new Semaphore(permits)))) {
            s = ns;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JavaIMAPProtocol.initAuthSemaphore: New semaphore for \"" + url + "\": " + s.toString());
            }
        }
        return s;
    }

    public JavaIMAPProtocol(String name, String host, int port, Properties props, boolean isSSL, MailLogger logger) throws IOException, ProtocolException {
        super(name, host, port, props, isSSL, logger);
        int maxNumAuthenticated;
        this.maxNumAuthenticated = maxNumAuthenticated = PropUtil.getIntProperty(props, "mail.imap.maxNumAuthenticated", 0);
        if (maxNumAuthenticated <= 0) {
            this.authTimeoutMillis = -1L;
            this.accountId = -1;
        } else {
            boolean noWait = PropUtil.getBooleanProperty(props, "mail.imap.authNoWait", false);
            if (noWait) {
                this.authTimeoutMillis = 0L;
            } else {
                boolean await = PropUtil.getBooleanProperty(props, "mail.imap.authAwait", false);
                if (await) {
                    this.authTimeoutMillis = -1L;
                } else {
                    int defaultTimeout = 10000;
                    int millis = PropUtil.getIntProperty(props, "mail.imap.authTimeoutMillis", 10000);
                    this.authTimeoutMillis = millis <= 0 ? 10000L : (long)millis;
                }
            }
            this.accountId = PropUtil.getIntProperty(props, "mail.imap.accountId", 0);
        }
    }

    @Override
    protected void authenticatedStatusChanging(boolean authenticate, String u, String p) throws ProtocolException {
        int maxNumAuthenticated = this.maxNumAuthenticated;
        if (maxNumAuthenticated <= 0) {
            return;
        }
        if (authenticate) {
            this.acquirePermit(u, p, maxNumAuthenticated);
        } else {
            this.releasePermits();
        }
    }

    protected void acquirePermit(String u, String p, int maxNumAuthenticated) throws ConnectQuotaExceededException, ProtocolException {
        boolean debug = this.logger.isLoggable(Level.FINE);
        Semaphore semaphore = this.semaphore;
        if (null == semaphore) {
            this.semaphore = semaphore = JavaIMAPProtocol.initAuthSemaphore(new URLName("imap", this.host, this.port, null, u, p), maxNumAuthenticated, this.logger);
        } else if (debug) {
            this.logger.fine("JavaIMAPProtocol.authenticated: semaphore already applied. -- protocol's permit count " + this.permitCount.get());
        }
        if (null != semaphore) {
            try {
                long start = debug ? System.currentTimeMillis() : 0L;
                long timeoutMillis = this.authTimeoutMillis;
                if (0L == timeoutMillis) {
                    if (debug) {
                        this.logger.fine("JavaIMAPProtocol.authenticated: performing limited login. no wait -- " + semaphore);
                    }
                    if (!semaphore.tryAcquire()) {
                        throw new ConnectQuotaExceededException("Max. number of connections exceeded. Try again later.");
                    }
                } else if (timeoutMillis > 0L) {
                    if (debug) {
                        this.logger.fine("JavaIMAPProtocol.authenticated: performing limited login. max wait time: " + timeoutMillis + " -- " + semaphore);
                    }
                    if (!semaphore.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS)) {
                        throw new ConnectQuotaExceededException("Max. number of connections exceeded. Try again later.");
                    }
                } else {
                    if (debug) {
                        this.logger.fine("JavaIMAPProtocol.authenticated: performing limited login. awaiting until a used connection gets closed -- " + semaphore);
                    }
                    semaphore.acquire();
                }
                this.permitCount.incrementAndGet();
                if (debug) {
                    long dur = System.currentTimeMillis() - start;
                    this.logger.fine("JavaIMAPProtocol.authenticated: login permitted (" + dur + "msec) -- " + semaphore + " -- protocol's permit count " + this.permitCount.get());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ProtocolException("Interrupted", e);
            }
        }
    }

    protected void releasePermits() {
        Semaphore semaphore = this.semaphore;
        if (null != semaphore) {
            int permits = this.permitCount.getAndSet(0);
            if (permits > 0) {
                semaphore.release(permits);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("JavaIMAPProtocol.logout: released login semaphore -- " + semaphore);
                }
            }
            this.semaphore = null;
        }
    }
}

