/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;

public final class QueueProvider {
    private static QueueProvider INSTANCE = new QueueProvider();

    public static QueueProvider getInstance() {
        return INSTANCE;
    }

    public <V> BlockingQueue<V> newSynchronousQueue() {
        return new SynchronousQueue();
    }

    public <V> BlockingQueue<V> newSynchronousQueue(Class<? extends V> clazz) {
        return new SynchronousQueue();
    }

    public final <V> BlockingQueue<V> newLinkedQueue(int fixedCapacity) {
        return fixedCapacity > 0 ? new LinkedBlockingQueue(fixedCapacity) : new LinkedBlockingQueue();
    }

    public final <V> BlockingQueue<V> newLinkedQueue(Class<? extends V> clazz, int fixedCapacity) {
        return fixedCapacity > 0 ? new LinkedBlockingQueue(fixedCapacity) : new LinkedBlockingQueue();
    }
}

