/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogProperties;
import com.openexchange.threadpool.internal.CustomThread;
import com.openexchange.threadpool.internal.CustomUncaughtExceptionhandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class CustomThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger();
    private final String namePrefix;
    private final int len;

    public CustomThreadFactory(String namePrefix) {
        this.namePrefix = namePrefix;
        this.len = namePrefix.length() + 7;
    }

    @Override
    public Thread newThread(Runnable r) {
        int threadNum = this.threadNumber.incrementAndGet();
        if (threadNum <= 0) {
            boolean check = false;
            do {
                if (this.threadNumber.compareAndSet(threadNum, 1)) {
                    threadNum = 1;
                    continue;
                }
                threadNum = this.threadNumber.get();
                check = true;
            } while (threadNum <= 0);
            if (check && 1 == threadNum) {
                threadNum = this.threadNumber.incrementAndGet();
            }
        }
        CustomThread t = new CustomThread(r, CustomThreadFactory.getThreadName(threadNum, new StringAllocator(this.len).append(this.namePrefix)));
        t.setUncaughtExceptionHandler(new CustomUncaughtExceptionhandler());
        LogProperties.cloneLogProperties((Thread)t);
        return t;
    }

    private static String getThreadName(int threadNumber, StringAllocator sb) {
        for (int i = threadNumber; i < 1000000; i *= 10) {
            sb.append('0');
        }
        return sb.append(threadNumber).toString();
    }
}

