/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool;

import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.threadpool.CancelableCompletionService;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadRenamer;
import com.openexchange.threadpool.Trackable;
import com.openexchange.threadpool.internal.CustomThreadFactory;
import com.openexchange.threadpool.osgi.ThreadPoolActivator;
import com.openexchange.timer.TimerService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;

public final class ThreadPools {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ThreadPools.class));
    public static final ExpectedExceptionFactory<OXException> DEFAULT_EXCEPTION_FACTORY = new ExpectedExceptionFactory<OXException>(){

        @Override
        public Class<OXException> getType() {
            return OXException.class;
        }

        @Override
        public OXException newUnexpectedError(Throwable t) {
            return new OXException(t);
        }
    };
    public static final ExecutorService CURRENT_THREAD_EXECUTOR_SERVICE = new CurrentThreadExecutorService();

    private ThreadPools() {
    }

    public static ThreadPoolService getThreadPool() {
        return ThreadPoolActivator.REF_THREAD_POOL.get();
    }

    public static TimerService getTimerService() {
        return ThreadPoolActivator.REF_TIMER.get();
    }

    public static void appendStackTrace(StackTraceElement[] trace, StringBuilder sb, String lineSeparator) {
        if (null == trace) {
            sb.append("<missing stack trace>\n");
            return;
        }
        for (StackTraceElement ste : trace) {
            String className = ste.getClassName();
            if (null == className) continue;
            sb.append("    at ").append(className).append('.').append(ste.getMethodName());
            if (ste.isNativeMethod()) {
                sb.append("(Native Method)");
            } else {
                String fileName = ste.getFileName();
                if (null == fileName) {
                    sb.append("(Unknown Source)");
                } else {
                    int lineNumber = ste.getLineNumber();
                    sb.append('(').append(fileName);
                    if (lineNumber >= 0) {
                        sb.append(':').append(lineNumber);
                    }
                    sb.append(')');
                }
            }
            sb.append(lineSeparator);
        }
    }

    public static void appendCurrentStackTrace(StringBuilder sb, String lineSeparator) {
        ThreadPools.appendStackTrace(new Throwable().getStackTrace(), sb, lineSeparator);
    }

    public static <R, E extends Exception> List<R> pollCompletionService(CompletionService<R> completionService, int size, long timeoutMillis, ExpectedExceptionFactory<E> factory) throws E {
        try {
            ArrayList<R> ret = new ArrayList<R>(size);
            for (int i = 0; i < size; ++i) {
                Future<R> f = completionService.poll(timeoutMillis, TimeUnit.MILLISECONDS);
                if (null != f) {
                    ret.add(f.get());
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)new StringBuilder(32).append("Completion service's task elapsed time-out of ").append(timeoutMillis).append("msec").toString());
            }
            return ret;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw factory.newUnexpectedError(e);
        }
        catch (ExecutionException e) {
            throw ThreadPools.launderThrowable(e, factory.getType());
        }
    }

    public static <R, E extends Exception> List<R> takeCompletionService(CompletionService<R> completionService, int size, ExpectedExceptionFactory<E> factory) throws E {
        try {
            ArrayList<R> ret = new ArrayList<R>(size);
            for (int i = 0; i < size; ++i) {
                ret.add(completionService.take().get());
            }
            return ret;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw factory.newUnexpectedError(e);
        }
        catch (ExecutionException e) {
            throw ThreadPools.launderThrowable(e, factory.getType());
        }
    }

    public static <E extends Exception> E launderThrowable(ExecutionException e, Class<E> expectedExceptionType) {
        Throwable t = e.getCause();
        if (null != expectedExceptionType && expectedExceptionType.isInstance(t)) {
            return (E)((Exception)expectedExceptionType.cast(t));
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException("Not unchecked", t);
    }

    public static <T> Task<T> task(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new TaskAdapter<T>(new RunnableAdapter<T>(task, result));
    }

    public static <T> Task<T> task(Runnable task, T result, boolean trackable) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableAdapter<T> callable = new RunnableAdapter<T>(task, result);
        return trackable ? new TrackableTaskAdapter<T>(callable) : new TaskAdapter<T>(callable);
    }

    public static Task<Object> task(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new TaskAdapter<Object>(new RunnableAdapter<Object>(task, null));
    }

    public static Task<Object> trackableTask(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new TrackableTaskAdapter<Object>(new RunnableAdapter<Object>(task, null));
    }

    public static Task<Object> task(Runnable task, boolean trackable) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableAdapter<Object> callable = new RunnableAdapter<Object>(task, null);
        return trackable ? new TrackableTaskAdapter<Object>(callable) : new TaskAdapter<Object>(callable);
    }

    public static Task<Object> task(Runnable task, String prefix) {
        if (task == null || prefix == null) {
            throw new NullPointerException();
        }
        return new RenamingTaskAdapter<Object>(new RunnableAdapter<Object>(task, null), prefix);
    }

    public static <T> Task<T> task(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new TaskAdapter<T>(task);
    }

    public static <T> Task<T> task(Callable<T> task, boolean trackable) {
        if (task == null) {
            throw new NullPointerException();
        }
        return trackable ? new TrackableTaskAdapter<T>(task) : new TaskAdapter<T>(task);
    }

    public static <T> Task<T> task(Callable<T> task, String prefix) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new RenamingTaskAdapter<T>(task, prefix);
    }

    public static ThreadFactory newThreadFactory(String namePrefix) {
        return new CustomThreadFactory(namePrefix);
    }

    public static <V> CancelableCompletionService<V> newCompletionService(ThreadPoolService threadPool) {
        return new ThreadPoolCompletionService(threadPool);
    }

    public static abstract class TrackableCallable<V>
    implements Callable<V>,
    Trackable {
        protected final Props props;

        protected TrackableCallable() {
            this(LogProperties.optLogProperties((Thread)Thread.currentThread()));
        }

        protected TrackableCallable(Props props) {
            this.props = props;
        }

        @Override
        public Props optLogProperties() {
            return this.props;
        }
    }

    private static class CurrentThreadExecutorService
    extends AbstractExecutorService {
        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    private static class TrackableRenamingTaskAdapter<V>
    extends RenamingTaskAdapter<V>
    implements Trackable {
        private final Props props = LogProperties.optLogProperties((Thread)Thread.currentThread());

        TrackableRenamingTaskAdapter(Callable<V> callable, String prefix) {
            super(callable, prefix);
        }

        @Override
        public Props optLogProperties() {
            return this.props;
        }
    }

    private static class RenamingTaskAdapter<V>
    implements Task<V> {
        private final Callable<V> callable;
        private final String prefix;

        RenamingTaskAdapter(Callable<V> callable, String prefix) {
            this.callable = callable;
            this.prefix = prefix;
        }

        @Override
        public void afterExecute(Throwable throwable) {
        }

        @Override
        public void beforeExecute(Thread thread) {
        }

        @Override
        public void setThreadName(ThreadRenamer threadRenamer) {
            threadRenamer.renamePrefix(this.prefix);
        }

        @Override
        public V call() throws Exception {
            return this.callable.call();
        }
    }

    private static class TrackableTaskAdapter<V>
    extends TaskAdapter<V>
    implements Trackable {
        private final Props props = LogProperties.optLogProperties((Thread)Thread.currentThread());

        TrackableTaskAdapter(Callable<V> callable) {
            super(callable);
        }

        @Override
        public Props optLogProperties() {
            return this.props;
        }
    }

    private static class TaskAdapter<V>
    implements Task<V> {
        private final Callable<V> callable;

        TaskAdapter(Callable<V> callable) {
            this.callable = callable;
        }

        @Override
        public void afterExecute(Throwable throwable) {
        }

        @Override
        public void beforeExecute(Thread thread) {
        }

        @Override
        public void setThreadName(ThreadRenamer threadRenamer) {
        }

        @Override
        public V call() throws Exception {
            return this.callable.call();
        }
    }

    private static class RunnableAdapter<T>
    implements Callable<T> {
        private final Runnable task;
        private final T result;

        RunnableAdapter(Runnable task, T result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public T call() {
            this.task.run();
            return this.result;
        }
    }

    public static interface ExpectedExceptionFactory<E extends Exception> {
        public Class<E> getType();

        public E newUnexpectedError(Throwable var1);
    }
}

