/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log.internal;

import com.openexchange.log.LogProperties;
import com.openexchange.log.LogService;
import com.openexchange.log.Loggable;
import com.openexchange.log.PropertiesAware;
import com.openexchange.log.Props;
import com.openexchange.log.internal.LoggableImpl;
import com.openexchange.log.internal.LoggerTask;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.behavior.AbortBehavior;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;

public final class LogServiceImpl
implements LogService {
    private static final int DEFAULT_CAPACITY = 8192;
    private final BlockingQueue<Loggable> queue;
    private final Future<Object> future;
    private final LoggerTask loggerTask;

    public LogServiceImpl(ThreadPoolService threadPool, int queueCapacity, int maxMessageLength) {
        this.queue = new LinkedBlockingQueue<Loggable>(queueCapacity > 0 ? queueCapacity : 8192);
        this.loggerTask = new LoggerTask(this.queue, maxMessageLength);
        this.future = threadPool.submit(this.loggerTask, AbortBehavior.getInstance());
    }

    public void stop() {
        this.loggerTask.stop();
        try {
            this.future.get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.future.cancel(true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void log(Loggable.Level level, Log log, Throwable throwable) {
        this.log(this.loggableFor(level, log, throwable.getMessage(), throwable));
    }

    public void log(Loggable loggable) {
        Log log = loggable.getLog();
        if (null == log) {
            return;
        }
        if (loggable.isLoggable()) {
            try {
                this.queue.offer(loggable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Loggable loggableFor(Loggable.Level level, Log log, Object message, Throwable throwable) {
        LoggableImpl loggable = new LoggableImpl(level, log, message, throwable, new Throwable());
        if (LogProperties.isEnabled() && !(message instanceof PropertiesAware)) {
            Props props = LogProperties.optLogProperties();
            loggable.putProperties(null == props ? null : props.getMap());
        }
        return loggable;
    }

    public Loggable loggableFor(Loggable.Level level, Log log, Object message) {
        LoggableImpl loggable = new LoggableImpl(level, log, message, null, new Throwable());
        if (LogProperties.isEnabled() && !(message instanceof PropertiesAware)) {
            Props props = LogProperties.optLogProperties();
            loggable.putProperties(null == props ? null : props.getMap());
        }
        return loggable;
    }
}

