/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2425;

import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.values.DateTimeValue;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.regex.Pattern;

public class DateTimeValueDefinition
extends ValueDefinition {
    public static final ValueDefinition Default = new DateTimeValueDefinition();
    private static Pattern TZPattern = Pattern.compile("[-+]\\d{2}:?\\d{2}");
    private static final DecimalFormat YearFormat = new DecimalFormat("0000");
    private static final DecimalFormat Format = new DecimalFormat("00");
    private static final DecimalFormat MSFormat = new DecimalFormat("000");

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        DateTimeValue date = new DateTimeValue();
        this.parseDate(s, date);
        if (s.peek != 84) {
            throw new VersitException(s, "Date and time expected");
        }
        s.read();
        this.parseTime(s, date);
        return date;
    }

    protected void parseDate(StringScanner s, DateTimeValue date) throws IOException {
        date.calendar.set(1, s.parseNumber(4));
        if (s.peek == 45) {
            s.read();
        }
        date.calendar.set(2, s.parseNumber(2) - 1);
        if (s.peek == 45) {
            s.read();
        }
        date.calendar.set(5, s.parseNumber(2));
    }

    protected void parseTime(StringScanner s, DateTimeValue date) throws IOException {
        date.calendar.set(11, s.parseNumber(2));
        this.skipColon(s);
        date.calendar.set(12, s.parseNumber(2));
        this.skipColon(s);
        date.calendar.set(13, s.parseNumber(2));
        if (s.peek == 46) {
            s.read();
            int ms = 0;
            for (int scale = 100; s.peek >= 48 && s.peek <= 57 && scale >= 1; scale /= 10) {
                ms += scale * (s.read() - 48);
            }
            date.calendar.set(14, ms);
            while (s.peek >= 48 && s.peek <= 57) {
                s.read();
            }
        }
        StringBuilder tz = new StringBuilder("GMT");
        if (s.peek == 90) {
            s.read();
        } else {
            String offs = s.regex(TZPattern);
            if (offs == null) {
                date.isFloating = true;
            } else {
                tz.append(offs);
                date.isUTC = false;
            }
        }
        date.calendar.setTimeZone(TimeZoneUtils.getTimeZone(tz.toString()));
    }

    private void skipColon(StringScanner s) throws IOException {
        if (s.peek == 92) {
            s.read();
        }
        if (s.peek == 58) {
            s.read();
        }
    }

    @Override
    public String writeValue(Object value) {
        DateTimeValue dtval = (DateTimeValue)value;
        StringBuilder sb = new StringBuilder();
        if (dtval.hasDate) {
            sb.append(this.writeDate(dtval));
        }
        if (dtval.hasTime) {
            sb.append('T');
            sb.append(this.writeTime(dtval));
        }
        return sb.toString();
    }

    protected String writeDate(DateTimeValue dtval) {
        return YearFormat.format(dtval.calendar.get(1)) + Format.format(dtval.calendar.get(2) + 1) + Format.format(dtval.calendar.get(5));
    }

    protected String writeTime(DateTimeValue dtval) {
        StringBuilder sb = new StringBuilder();
        sb.append(Format.format(dtval.calendar.get(11)));
        sb.append(Format.format(dtval.calendar.get(12)));
        sb.append(Format.format(dtval.calendar.get(13)));
        int ms = dtval.calendar.get(14);
        if (ms != 0) {
            sb.append('.');
            sb.append(MSFormat.format(ms));
        }
        if (!dtval.isFloating) {
            int offset = dtval.calendar.getTimeZone().getRawOffset();
            if (dtval.isUTC || offset == 0) {
                sb.append('Z');
            } else {
                sb.append(offset > 0 ? (char)'+' : '-');
                sb.append(Format.format(offset / 3600000));
                sb.append(Format.format(offset / 60000 % 60));
            }
        }
        return sb.toString();
    }
}

