/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.file.external.FileStorage;
import com.openexchange.tools.file.external.FileStorageCodes;
import com.openexchange.tools.file.internal.HashingFileStorage;
import com.openexchange.tools.file.internal.RandomAccessFileInputStream;
import it.geosolutions.imageio.stream.eraf.EnhancedRandomAccessFile;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.logging.Log;

public abstract class DefaultFileStorage
implements FileStorage {
    private static final String READ = "r";
    private static final String READ_WRITE = "rw";
    protected final File storage;

    public DefaultFileStorage(File storage) {
        this.storage = storage;
    }

    protected File file(String name) {
        return new File(this.storage, name);
    }

    protected EnhancedRandomAccessFile eraf(String name, boolean readOnly) throws OXException {
        File file = this.file(name);
        try {
            return new EnhancedRandomAccessFile(file, readOnly ? READ : READ_WRITE);
        }
        catch (FileNotFoundException e) {
            throw FileStorageCodes.FILE_NOT_FOUND.create(e, file.getAbsolutePath());
        }
        catch (IOException e) {
            throw FileStorageCodes.IOERROR.create(e, e.getMessage());
        }
    }

    protected RandomAccessFile raf(String name, boolean readOnly) throws OXException {
        File file = this.file(name);
        try {
            return new RandomAccessFile(file, readOnly ? READ : READ_WRITE);
        }
        catch (FileNotFoundException e) {
            throw FileStorageCodes.FILE_NOT_FOUND.create(file.getAbsolutePath());
        }
    }

    @Override
    public boolean deleteFile(String identifier) throws OXException {
        return this.file(identifier).delete();
    }

    @Override
    public Set<String> deleteFiles(String[] identifiers) throws OXException {
        HashSet<String> notDeleted = new HashSet<String>();
        for (String identifier : identifiers) {
            if (this.deleteFile(identifier)) continue;
            notDeleted.add(identifier);
        }
        return notDeleted;
    }

    @Override
    public InputStream getFile(String name) throws OXException {
        try {
            return new BufferedInputStream(new FileInputStream(this.file(name)));
        }
        catch (FileNotFoundException e) {
            throw FileStorageCodes.FILE_NOT_FOUND.create(name);
        }
    }

    @Override
    public long getFileSize(String name) throws OXException {
        File file = this.file(name);
        if (!file.exists()) {
            throw FileStorageCodes.FILE_NOT_FOUND.create(name);
        }
        return file.length();
    }

    @Override
    public String getMimeType(String name) throws OXException {
        MimetypesFileTypeMap map = new MimetypesFileTypeMap();
        return map.getContentType(this.file(name));
    }

    @Override
    public InputStream getFile(String name, long offset, long length) throws OXException {
        EnhancedRandomAccessFile eraf = this.eraf(name, true);
        try {
            if (offset > eraf.length() || -1L != length && length > eraf.length() - offset) {
                throw FileStorageCodes.INVALID_RANGE.create(offset, length, name, eraf.length());
            }
            return new RandomAccessFileInputStream(eraf, offset, length);
        }
        catch (FileNotFoundException e) {
            throw FileStorageCodes.FILE_NOT_FOUND.create(name);
        }
        catch (IOException e) {
            throw FileStorageCodes.IOERROR.create(e, e.getMessage());
        }
    }

    @Override
    public long appendToFile(InputStream file, String name, long offset) throws OXException {
        EnhancedRandomAccessFile eraf = null;
        try {
            int read;
            eraf = this.eraf(name, false);
            if (offset != eraf.length()) {
                throw FileStorageCodes.INVALID_OFFSET.create(offset, name, eraf.length());
            }
            eraf.seek(eraf.length());
            byte[] buffer = new byte[8192];
            while (0 < (read = file.read(buffer, 0, buffer.length))) {
                eraf.write(buffer, 0, read);
            }
            eraf.flush();
            long l = eraf.length();
            return l;
        }
        catch (IOException e) {
            throw FileStorageCodes.IOERROR.create(e, e.getMessage());
        }
        finally {
            if (null != eraf) {
                try {
                    eraf.close();
                }
                catch (IOException e) {
                    com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(HashingFileStorage.class)).warn((Object)"error closing random access file", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setFileLength(long length, String name) throws OXException {
        RandomAccessFile raf = null;
        try {
            raf = this.raf(name, false);
            if (length > raf.length()) {
                throw FileStorageCodes.INVALID_LENGTH.create(length, name, raf.length());
            }
            raf.setLength(length);
        }
        catch (IOException e) {
            try {
                throw FileStorageCodes.IOERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Streams.close(raf);
                throw throwable;
            }
        }
        Streams.close((Closeable)raf);
    }
}

