/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.exceptions;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import java.util.Map;
import java.util.TreeMap;

public class ExceptionUtils {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ExceptionUtils.class));
    private static final String MARKER = " ---=== /!\\ ===--- ";

    public static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            Map taskProperties;
            Props props = LogProperties.optLogProperties();
            Map map = taskProperties = null == props ? null : props.asMap();
            if (null == taskProperties) {
                LOG.fatal((Object)" ---=== /!\\ ===--- Thread death ---=== /!\\ ===--- ", t);
            } else {
                StringBuilder logBuilder = new StringBuilder(512);
                TreeMap<String, String> sorted = new TreeMap<String, String>();
                for (Map.Entry entry : taskProperties.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (null == value) continue;
                    sorted.put(propertyName, value.toString());
                }
                for (Map.Entry entry : sorted.entrySet()) {
                    logBuilder.append('\n').append((String)entry.getKey()).append('=').append((String)entry.getValue());
                }
                logBuilder.deleteCharAt(0);
                logBuilder.append("\n\n");
                logBuilder.append(MARKER);
                logBuilder.append("Thread death");
                logBuilder.append(MARKER);
                LOG.fatal((Object)logBuilder.toString(), t);
            }
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            Map taskProperties;
            Props props = LogProperties.optLogProperties();
            Map map = taskProperties = null == props ? null : props.asMap();
            if (null == taskProperties) {
                LOG.fatal((Object)" ---=== /!\\ ===--- The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating. ---=== /!\\ ===--- ", t);
            } else {
                StringAllocator logBuilder = new StringAllocator(512);
                TreeMap<String, String> sorted = new TreeMap<String, String>();
                for (Map.Entry entry : taskProperties.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (null == value) continue;
                    sorted.put(propertyName, value.toString());
                }
                for (Map.Entry entry : sorted.entrySet()) {
                    logBuilder.append('\n').append((String)entry.getKey()).append('=').append((String)entry.getValue());
                }
                logBuilder.deleteCharAt(0);
                logBuilder.append("\n\n");
                logBuilder.append(MARKER);
                logBuilder.append("The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating.");
                logBuilder.append(MARKER);
                LOG.fatal((Object)logBuilder.toString(), t);
            }
            throw (VirtualMachineError)t;
        }
    }

    private static String surroundWithMarker(String message) {
        return new StringAllocator(message.length() + 40).append(MARKER).append(message).append(MARKER).toString();
    }
}

