/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.services;

import com.openexchange.i18n.I18nService;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class I18nServices {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(I18nServices.class));
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static final I18nServices SINGLETON = new I18nServices();
    private final Map<Locale, I18nService> services = new ConcurrentHashMap<Locale, I18nService>();

    private I18nServices() {
    }

    public void addService(I18nService service) {
        if (null != this.services.put(service.getLocale(), service)) {
            LOG.warn((Object)("Another i18n translation service found for " + service.getLocale()));
        }
    }

    public void removeService(I18nService service) {
        if (null == this.services.remove(service.getLocale())) {
            LOG.warn((Object)("Unknown i18n translation service shut down for " + service.getLocale()));
        }
    }

    public static I18nServices getInstance() {
        return SINGLETON;
    }

    public I18nService getService(Locale locale) {
        return this.getService(null == locale ? DEFAULT_LOCALE : locale, true);
    }

    public I18nService getService(Locale locale, boolean warn) {
        Locale loc = null == locale ? DEFAULT_LOCALE : locale;
        I18nService retval = this.services.get(loc);
        if (warn && null == retval && !"en".equalsIgnoreCase(loc.getLanguage())) {
            LOG.warn((Object)("No i18n service for locale " + loc + "."));
        }
        return retval;
    }

    public String translate(Locale locale, String toTranslate) {
        return this.translate(locale, toTranslate, true);
    }

    public String translate(Locale locale, String toTranslate, boolean warn) {
        Locale loc = null == locale ? DEFAULT_LOCALE : locale;
        I18nService service = this.getService(loc, warn);
        if (null == service) {
            return toTranslate;
        }
        if (warn && !service.hasKey(toTranslate)) {
            LOG.warn((Object)("I18n service for locale " + loc + " has no translation for \"" + toTranslate + "\"."));
            return toTranslate;
        }
        return service.getLocalized(toTranslate);
    }

    public String translate(String localeId, String toTranslate) {
        return this.translate(LocaleTools.getLocale((String)localeId), toTranslate);
    }

    public void clear() {
        this.services.clear();
    }
}

