/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import org.apache.commons.logging.Log;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class HostnameServiceCustomizer
implements ServiceTrackerCustomizer<HostnameService, HostnameService> {
    private static final Log LOG = LogFactory.getLog(HostnameServiceCustomizer.class);
    private final BundleContext context;

    public HostnameServiceCustomizer(BundleContext context) {
        this.context = context;
    }

    public HostnameService addingService(ServiceReference<HostnameService> reference) {
        HostnameService addedService = (HostnameService)this.context.getService(reference);
        if (null == addedService) {
            LOG.warn((Object)"Added service is null!", new Throwable());
            return addedService;
        }
        if (ServerServiceRegistry.getInstance().getService(HostnameService.class) == null) {
            ServerServiceRegistry.getInstance().addService(HostnameService.class, addedService);
        } else {
            LOG.error((Object)"Several hostname services found. Remove all except one!");
        }
        return addedService;
    }

    public void modifiedService(ServiceReference<HostnameService> reference, HostnameService service) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"HostnameURLCustomizer.modifiedService()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<HostnameService> reference, HostnameService service) {
        try {
            ServerServiceRegistry.getInstance().removeService(HostnameService.class);
        }
        finally {
            this.context.ungetService(reference);
        }
    }
}

