/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.authorization.Authorization;
import com.openexchange.authorization.AuthorizationService;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class AuthorizationCustomizer
implements ServiceTrackerCustomizer<AuthorizationService, AuthorizationService> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AuthorizationCustomizer.class));
    private final BundleContext context;

    public AuthorizationCustomizer(BundleContext context) {
        this.context = context;
    }

    public AuthorizationService addingService(ServiceReference<AuthorizationService> reference) {
        AuthorizationService auth = (AuthorizationService)this.context.getService(reference);
        if (null == Authorization.getService()) {
            Authorization.setService(auth);
            return auth;
        }
        this.context.ungetService(reference);
        LOG.error((Object)"Several authorization services found. Remove all except one!");
        return null;
    }

    public void modifiedService(ServiceReference<AuthorizationService> reference, AuthorizationService service) {
    }

    public void removedService(ServiceReference<AuthorizationService> reference, AuthorizationService service) {
        if (Authorization.dropService(service)) {
            LOG.error((Object)"Removed authorization service was not active!");
        } else {
            this.context.ungetService(reference);
        }
    }
}

