/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.internal;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class Tools {
    public static final Map<String, Integer> getAllSchemata(Log logger) throws SQLException, OXException {
        Connection readcon;
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        LinkedHashMap<String, Integer> schemaMap = new LinkedHashMap<String, Integer>(50);
        try {
            readcon = dbService.getReadOnly();
        }
        catch (OXException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = readcon.createStatement();
            rs = statement.executeQuery("SELECT read_db_pool_id, db_schema FROM context_server2db_pool GROUP BY db_schema");
            while (rs.next()) {
                schemaMap.put(rs.getString(2), rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, statement);
                dbService.backReadOnly(readcon);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, statement);
        dbService.backReadOnly(readcon);
        return schemaMap;
    }
}

