/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.internal;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.management.ManagementService;
import com.openexchange.report.Constants;
import com.openexchange.report.internal.LoginCounter;
import com.openexchange.report.internal.LoginCounterImpl;
import com.openexchange.report.internal.ReportingMBean;
import com.openexchange.server.Initialization;

public class ReportingInit
implements Initialization {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ReportingInit.class));
    private final ManagementService managementService;

    public ReportingInit(ManagementService managementService) {
        this.managementService = managementService;
    }

    public void start() {
        try {
            this.managementService.registerMBean(Constants.REPORTING_NAME, (Object)new ReportingMBean());
            this.managementService.registerMBean(Constants.LOGIN_COUNTER_NAME, (Object)new LoginCounter(new LoginCounterImpl()));
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.managementService.unregisterMBean(Constants.REPORTING_NAME);
            this.managementService.unregisterMBean(Constants.LOGIN_COUNTER_NAME);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

