/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.passwordchange;

import com.openexchange.authentication.AuthenticationService;
import com.openexchange.authentication.LoginInfo;
import com.openexchange.authentication.service.Authentication;
import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.passwordchange.PasswordChangeEvent;
import com.openexchange.passwordchange.PasswordMechanism;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public abstract class PasswordChangeService {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(PasswordChangeService.class));
    private static final Pattern PATTERN_ALLOWED_CHARS = Pattern.compile("[ $@%\\.+a-zA-Z0-9_-]+");

    protected PasswordChangeService() {
    }

    public final void perform(PasswordChangeEvent event) throws OXException {
        this.allow(event);
        this.check(event);
        this.update(event);
        this.propagate(event);
    }

    protected void allow(PasswordChangeEvent event) throws OXException {
        Context context = event.getContext();
        if (!UserConfigurationStorage.getInstance().getUserConfiguration(event.getSession().getUserId(), context).isEditPassword()) {
            throw UserExceptionCode.PERMISSION.create(context.getContextId());
        }
    }

    protected void check(PasswordChangeEvent event) throws OXException {
        AuthenticationService authenticationService = Authentication.getService();
        if (authenticationService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{AuthenticationService.class.getName()});
        }
        Session session = event.getSession();
        UserStorage.getStorageUser(session.getUserId(), event.getContext());
        authenticationService.handleLoginInfo((LoginInfo)new _LoginInfo(session.getLogin(), event.getOldPassword()));
        int len = event.getNewPassword().length();
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        int property = service.getIntProperty("com.openexchange.passwordchange.minLength", 4);
        if (property > 0 && len < property) {
            throw UserExceptionCode.INVALID_MIN_LENGTH.create(property);
        }
        property = service.getIntProperty("com.openexchange.passwordchange.maxLength", 0);
        if (property > 0 && len > property) {
            throw UserExceptionCode.INVALID_MAX_LENGTH.create(property);
        }
    }

    protected abstract void update(PasswordChangeEvent var1) throws OXException;

    protected void propagate(PasswordChangeEvent event) throws OXException {
        CacheService cacheService;
        Session session = event.getSession();
        MailAccess.getMailAccessCache().removeMailAccess(session, 0);
        int userId = session.getUserId();
        UserStorage.getInstance().invalidateUser(event.getContext(), userId);
        ServerServiceRegistry serviceRegistry = ServerServiceRegistry.getInstance();
        SessiondService sessiondService = serviceRegistry.getService(SessiondService.class);
        if (sessiondService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
        }
        try {
            sessiondService.changeSessionPassword(session.getSessionID(), event.getNewPassword());
        }
        catch (OXException e) {
            LOG.error((Object)"Updating password in user session failed", (Throwable)e);
            throw e;
        }
        EventAdmin eventAdmin = serviceRegistry.getService(EventAdmin.class);
        int contextId = session.getContextId();
        if (null != eventAdmin) {
            HashMap<String, Object> properties = new HashMap<String, Object>(5);
            properties.put("com.openexchange.passwordchange.contextId", contextId);
            properties.put("com.openexchange.passwordchange.userId", userId);
            properties.put("com.openexchange.passwordchange.session", session);
            properties.put("com.openexchange.passwordchange.oldPassword", event.getOldPassword());
            properties.put("com.openexchange.passwordchange.newPassword", event.getNewPassword());
            eventAdmin.postEvent(new Event("com/openexchange/passwordchange", properties));
        }
        if (null != (cacheService = serviceRegistry.getService(CacheService.class))) {
            try {
                CacheKey key = cacheService.newCacheKey(contextId, userId);
                Cache jcs = cacheService.getCache("User");
                jcs.remove((Serializable)key);
                jcs = cacheService.getCache("UserPermissionBits");
                jcs.remove((Serializable)key);
                jcs = cacheService.getCache("UserConfiguration");
                jcs.remove((Serializable)key);
                jcs = cacheService.getCache("UserSettingMail");
                jcs.remove((Serializable)key);
                jcs = cacheService.getCache("MailAccount");
                jcs.remove((Serializable)cacheService.newCacheKey(contextId, new Serializable[]{Integer.valueOf(0), Integer.valueOf(userId)}));
                jcs.invalidateGroup(Integer.toString(contextId));
            }
            catch (OXException e) {
                // empty catch block
            }
        }
    }

    protected static final String getEncodedPassword(String mech, String newPassword) throws OXException {
        try {
            String cryptedPassword = PasswordMechanism.getEncodedPassword(mech, newPassword);
            if (null == cryptedPassword) {
                throw UserExceptionCode.MISSING_PASSWORD_MECH.create(mech == null ? "" : mech);
            }
            return cryptedPassword;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"Error encrypting password according to CRYPT mechanism", (Throwable)e);
            throw UserExceptionCode.UNSUPPORTED_ENCODING.create(e, e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"Error encrypting password according to SHA mechanism", (Throwable)e);
            throw UserExceptionCode.UNSUPPORTED_ENCODING.create(e, e.getMessage());
        }
    }

    protected static final boolean validatePassword(String password) {
        return PATTERN_ALLOWED_CHARS.matcher(password).matches();
    }

    protected static final class _LoginInfo
    implements LoginInfo {
        private final String pw;
        private final String loginInfo;

        public _LoginInfo(String loginInfo, String pw) {
            this.loginInfo = loginInfo;
            this.pw = pw;
        }

        public String getPassword() {
            return this.pw;
        }

        public String getUsername() {
            return this.loginInfo;
        }

        public Map<String, Object> getProperties() {
            return Collections.emptyMap();
        }
    }
}

