/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.context.ContextService;
import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.java.StringAllocator;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.user.UserService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;

public final class UnifiedInboxManagementImpl
implements UnifiedInboxManagement {
    private static final String SQL_CHECK = "SELECT url FROM user_mail_account WHERE cid = ? AND user = ? AND name = ?";
    private static final String SQL_ENABLED = "SELECT id FROM user_mail_account WHERE cid = ? AND user = ? AND unified_inbox > 0";

    @Override
    public void createUnifiedINBOX(int userId, int contextId) throws OXException {
        this.createUnifiedINBOX(userId, contextId, null);
    }

    @Override
    public void createUnifiedINBOX(int userId, int contextId, Connection con) throws OXException {
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        if (this.exists(userId, contextId, con)) {
            throw MailAccountExceptionCodes.DUPLICATE_UNIFIED_INBOX_ACCOUNT.create(userId, contextId);
        }
        ContextService contextService = ServerServiceRegistry.getInstance().getService(ContextService.class);
        Context ctx = null == contextService ? ContextStorage.getStorageContext(contextId) : contextService.getContext(contextId);
        MailAccountDescription mailAccountDescription = new MailAccountDescription();
        mailAccountDescription.setName(NAME_UNIFIED_INBOX);
        mailAccountDescription.setConfirmedHam("confirmed-ham");
        mailAccountDescription.setConfirmedSpam("confirmed-spam");
        mailAccountDescription.setDefaultFlag(false);
        mailAccountDescription.setDrafts("drafts");
        String login = UnifiedInboxManagementImpl.getUserLogin(userId, ctx);
        mailAccountDescription.setLogin(login);
        mailAccountDescription.setMailPort(143);
        mailAccountDescription.setMailProtocol(PROTOCOL_UNIFIED_INBOX);
        mailAccountDescription.setMailSecure(false);
        mailAccountDescription.setMailServer("localhost");
        mailAccountDescription.setPassword("");
        mailAccountDescription.setPrimaryAddress(new StringAllocator(32).append(login).append("@unifiedinbox.com").toString());
        mailAccountDescription.setSent("sent");
        mailAccountDescription.setSpam("spam");
        mailAccountDescription.setSpamHandler("NoSpamHandler");
        mailAccountDescription.setTransportServer((String)null);
        mailAccountDescription.setTrash("trash");
        if (null == con) {
            storageService.insertMailAccount(mailAccountDescription, userId, ctx, null);
        } else {
            storageService.insertMailAccount(mailAccountDescription, userId, ctx, null, con);
        }
        try {
            SessiondService sessiondService = (SessiondService)SessiondService.SERVICE_REFERENCE.get();
            if (null != sessiondService) {
                for (Session session : sessiondService.getSessions(userId, contextId)) {
                    session.setParameter("com.openexchange.mailaccount.unifiedMailAccountId", null);
                }
            }
        }
        catch (Exception e) {
        }
    }

    @Override
    public void deleteUnifiedINBOX(int userId, int contextId) throws OXException {
        this.deleteUnifiedINBOX(userId, contextId, null);
    }

    @Override
    public void deleteUnifiedINBOX(int userId, int contextId, Connection con) throws OXException {
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        MailAccount[] existingAccounts = storageService.getUserMailAccounts(userId, contextId);
        int id = -1;
        for (int i = 0; i < existingAccounts.length && id < 0; ++i) {
            MailAccount mailAccount = existingAccounts[i];
            if (!UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(mailAccount.getMailProtocol())) continue;
            id = mailAccount.getId();
        }
        if (id >= 0) {
            if (null == con) {
                storageService.deleteMailAccount(id, Collections.<String, Object>emptyMap(), userId, contextId, false);
            } else {
                storageService.deleteMailAccount(id, Collections.<String, Object>emptyMap(), userId, contextId, false, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(int userId, int contextId) throws OXException {
        Connection con = Database.get(contextId, false);
        try {
            boolean bl = this.exists(userId, contextId, con);
            return bl;
        }
        finally {
            Database.backAfterReading(contextId, con);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(int userId, int contextId, Connection con) throws OXException {
        boolean bl;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            boolean url2;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement(SQL_CHECK);
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
                stmt.setString(3, NAME_UNIFIED_INBOX);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String url2 = rs.getString(1);
                    if (rs.wasNull() || url2 == null || !url2.startsWith(UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX, 0)) continue;
                    bl = true;
                    break block6;
                }
                url2 = false;
            }
            catch (SQLException e) {
                try {
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(rs, stmt);
            return url2;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled(int userId, int contextId) throws OXException {
        Connection con = Database.get(contextId, false);
        try {
            boolean bl = this.isEnabled(userId, contextId, con);
            return bl;
        }
        finally {
            Database.back(contextId, false, con);
        }
    }

    @Override
    public boolean isEnabled(int userId, int contextId, Connection con) throws OXException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(SQL_ENABLED);
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return bl;
    }

    @Override
    public int getUnifiedINBOXAccountID(Session session) throws OXException {
        Integer i = (Integer)session.getParameter("com.openexchange.mailaccount.unifiedMailAccountId");
        if (null != i) {
            return i;
        }
        int unifiedINBOXAccountId = this.getUnifiedINBOXAccountID(session.getUserId(), session.getContextId());
        session.setParameter("com.openexchange.mailaccount.unifiedMailAccountId", (Object)unifiedINBOXAccountId);
        return unifiedINBOXAccountId;
    }

    @Override
    public int getUnifiedINBOXAccountID(int userId, int contextId) throws OXException {
        return this.getUnifiedINBOXAccountID(userId, contextId, null);
    }

    @Override
    public int getUnifiedINBOXAccountID(int userId, int contextId, Connection con) throws OXException {
        int n;
        boolean releaseConnection;
        Connection connection;
        DatabaseService databaseService;
        if (null == con) {
            databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class, true);
            connection = databaseService.getReadOnly(contextId);
            releaseConnection = true;
        } else {
            databaseService = null;
            connection = con;
            releaseConnection = false;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.prepareStatement("SELECT id FROM user_mail_account WHERE cid = ? AND user = ? AND url LIKE ?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setString(3, UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX + '%');
            rs = stmt.executeQuery();
            n = rs.next() ? rs.getInt(1) : -1;
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (releaseConnection && null != databaseService) {
                    databaseService.backReadOnly(contextId, connection);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (releaseConnection && null != databaseService) {
            databaseService.backReadOnly(contextId, connection);
        }
        return n;
    }

    private static String getUserLogin(int userId, Context ctx) throws OXException {
        UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class, true);
        return userService.getUser(userId, ctx).getLoginInfo();
    }
}

