/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.uuencode;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;

public class UUEncodedBodyPart {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(UUEncodedBodyPart.class));
    private static final String BEGIN = "begin";
    private static final String END = "end";
    private static final char LINE_SEPARATOR = '\n';
    private final InputStream bodyPartInputStream;
    private final String bodyPart;
    private String fileName = null;
    private int headerIndex = -1;
    private int endIndex = -1;
    private int fileSize = -1;

    public UUEncodedBodyPart(String bodyPart) throws MessagingException {
        this(bodyPart, true);
    }

    private UUEncodedBodyPart(String bodyPart, boolean initialize) throws MessagingException {
        this.bodyPart = bodyPart;
        if (initialize && this.findUUEncodedAttachmentPosition()) {
            ByteArrayInputStream bStream = new ByteArrayInputStream(bodyPart.substring(this.headerIndex, this.endIndex + 3).getBytes());
            this.bodyPartInputStream = MimeUtility.decode((InputStream)bStream, (String)"uuencode");
        } else {
            this.bodyPartInputStream = null;
        }
    }

    public static final boolean findUUEncodedAttachmentPosition(String bodyPart) throws MessagingException {
        return new UUEncodedBodyPart(bodyPart, false).findUUEncodedAttachmentPosition();
    }

    private boolean findUUEncodedAttachmentPosition() {
        int beginIndex = -1;
        String sSearch = this.bodyPart;
        beginIndex = sSearch.lastIndexOf(BEGIN);
        if (beginIndex != -1) {
            int eolIndex = sSearch.indexOf(10, beginIndex);
            String possibleHeader = sSearch.substring(beginIndex, eolIndex);
            StringTokenizer st = new StringTokenizer(possibleHeader);
            st.nextToken();
            try {
                String possibleFileSize = st.nextToken();
                this.fileSize = Integer.parseInt(possibleFileSize);
                this.fileName = st.nextToken();
                this.headerIndex = beginIndex;
                this.endIndex = sSearch.indexOf(END, beginIndex);
                return true;
            }
            catch (NoSuchElementException nsee) {
                LOG.error((Object)nsee.getMessage(), (Throwable)nsee);
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)nfe.getMessage(), (Throwable)nfe);
            }
        }
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputStream getInputStream() {
        return this.bodyPartInputStream;
    }

    public int getFileSize() {
        return this.fileSize;
    }
}

