/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.contact.ContactService;
import com.openexchange.groupware.contact.ContactUtil;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.util.MsisdnCheck;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.util.Set;
import javax.mail.internet.InternetAddress;

public class MsisdnUtility {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MsisdnUtility.class));

    private MsisdnUtility() {
    }

    public static void addMsisdnAddress(Set<InternetAddress> addresses, Session session) {
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
        if (null != contactService) {
            try {
                Contact contact = contactService.getUser(session, session.getUserId());
                Set<String> set = ContactUtil.gatherTelephoneNumbers(contact);
                for (String number : set) {
                    try {
                        addresses.add(new QuotedInternetAddress(MsisdnCheck.cleanup((String)number)));
                    }
                    catch (Exception e) {
                        LOG.debug((Object)("Ignoring invalid number: " + number), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not check for valid MSISDN numbers.", (Throwable)e);
            }
        }
    }
}

