/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.text;

import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

public final class TextProcessing {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TextProcessing.class));
    private static final String SPLIT_LINES = "\r?\n";
    private static final char CHAR_BREAK = '\n';

    private static String foldLine(String line, int linewrap, String prefix) {
        int mlen;
        char c;
        int end;
        String foldMe;
        int used;
        if (null == prefix) {
            used = 0;
            foldMe = line;
        } else {
            used = prefix.length();
            foldMe = line.substring(used);
        }
        for (end = mlen = foldMe.length() - 1; end >= 0 && ((c = foldMe.charAt(end)) == ' ' || c == '\t' || c == '\r' || c == '\n'); --end) {
        }
        String s = end != mlen ? foldMe.substring(0, end + 1) : foldMe;
        int total = used + s.length();
        if (total <= linewrap) {
            return used > 0 ? new StringAllocator(total).append(prefix).append(s).toString() : s;
        }
        StringAllocator sb = new StringAllocator(total);
        int lastc = 0;
        if (used > 0) {
            while (total > linewrap) {
                int lastspace = -1;
                for (int i = 0; i < s.length() && (lastspace == -1 || used + i <= linewrap); ++i) {
                    c = s.charAt(i);
                    if ((c == ' ' || c == '\t') && lastc != 32 && lastc != 9) {
                        lastspace = i;
                    }
                    lastc = c;
                }
                if (lastspace < 0) {
                    sb.append(prefix).append(s);
                    return sb.toString();
                }
                sb.append(prefix);
                sb.append(s.substring(0, lastspace));
                sb.append('\n');
                lastc = s.charAt(lastspace);
                s = s.substring(lastspace + 1);
                total = used + s.length();
            }
            sb.append(prefix).append(s);
            return sb.toString();
        }
        while (s.length() > linewrap) {
            int lastspace = -1;
            for (int i = 0; i < s.length() && (lastspace == -1 || i <= linewrap); ++i) {
                c = s.charAt(i);
                if ((c == ' ' || c == '\t') && lastc != 32 && lastc != 9) {
                    lastspace = i;
                }
                lastc = c;
            }
            if (lastspace < 0) {
                sb.append(s);
                return sb.toString();
            }
            sb.append(s.substring(0, lastspace));
            sb.append('\n');
            lastc = s.charAt(lastspace);
            s = s.substring(lastspace + 1);
        }
        sb.append(s);
        return sb.toString();
    }

    public static String performLineFolding(String content, int linewrap) {
        if (linewrap <= 0) {
            return content;
        }
        String[] lines = content.split(SPLIT_LINES);
        if (lines.length > 0) {
            StringAllocator sb = new StringAllocator(content.length() + 128);
            String foldMe = lines[0];
            sb.append(TextProcessing.foldLine(foldMe, linewrap, TextProcessing.getQuotePrefix(foldMe)));
            for (int i = 1; i < lines.length; ++i) {
                String foldMe2 = lines[i];
                sb.append('\n').append(TextProcessing.foldLine(foldMe2, linewrap, TextProcessing.getQuotePrefix(foldMe2)));
            }
            return sb.toString();
        }
        return content;
    }

    private static String getQuotePrefix(String line) {
        if (line.length() == 0) {
            return null;
        }
        int length = line.length();
        StringAllocator sb = new StringAllocator(8);
        int lastGT = -1;
        for (int i = 0; i < length; ++i) {
            char c = line.charAt(i);
            if (c == '>') {
                sb.append(c);
                lastGT = i;
                continue;
            }
            if (!Strings.isWhitespace((char)c)) break;
            sb.append(c);
        }
        if (lastGT == -1) {
            return null;
        }
        int len = sb.length();
        if (lastGT + 2 < len) {
            sb.delete(lastGT + 2, len);
        }
        return sb.toString();
    }

    public static String extractTextFrom(MailMessage mail) throws OXException {
        MailPart mailPart = TextProcessing.extractTextFrom(mail, 0);
        if (null == mailPart) {
            return "";
        }
        try {
            ContentType contentType = mailPart.getContentType();
            if (!contentType.startsWith("text/htm")) {
                return TextProcessing.readContent(mailPart, contentType);
            }
            String html = TextProcessing.readContent(mailPart, contentType);
            HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
            return htmlService.html2text(html, true);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private static MailPart extractTextFrom(MailPart mailPart, int altLevel) throws OXException {
        if (!mailPart.containsContentType()) {
            return null;
        }
        ContentType contentType = mailPart.getContentType();
        if (contentType.startsWith("text/")) {
            return altLevel <= 0 || contentType.startsWith("text/htm") ? mailPart : null;
        }
        if (contentType.startsWith("multipart/")) {
            boolean isAlternative = contentType.startsWith("multipart/alternative");
            int alternative = altLevel;
            if (isAlternative) {
                ++alternative;
            }
            int count = mailPart.getEnclosedCount();
            MailPart textPart = null;
            for (int i = 0; i < count; ++i) {
                MailPart enclosedPart = mailPart.getEnclosedMailPart(i);
                MailPart ret = TextProcessing.extractTextFrom(enclosedPart, alternative);
                if (null != ret) {
                    return ret;
                }
                if (!isAlternative || null != textPart || !enclosedPart.getContentType().startsWith("text/")) continue;
                textPart = enclosedPart;
            }
            if (isAlternative) {
                --alternative;
                if (null != textPart) {
                    return textPart;
                }
            }
        }
        return null;
    }

    private static String readContent(MailPart mailPart, ContentType contentType) throws OXException, IOException {
        String charset = TextProcessing.getCharset(mailPart, contentType);
        try {
            return MessageUtility.readMailPart(mailPart, charset);
        }
        catch (CharConversionException e) {
            String fallback = "US-ASCII";
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)new StringAllocator("Character conversion exception while reading content with charset \"").append(charset).append("\". Using fallback charset \"").append("US-ASCII").append("\" instead."), (Throwable)e);
            }
            return MessageUtility.readMailPart(mailPart, "US-ASCII");
        }
    }

    private static String getCharset(MailPart mailPart, ContentType contentType) throws OXException {
        String charset;
        if (mailPart.containsHeader("Content-Type")) {
            String cs = contentType.getCharsetParameter();
            if (!CharsetDetector.isValid((String)cs)) {
                StringAllocator sb = null;
                if (null != cs) {
                    sb = new StringAllocator(64).append("Illegal or unsupported encoding: \"").append(cs).append("\".");
                }
                if (contentType.startsWith("text/")) {
                    cs = CharsetDetector.detectCharset((InputStream)mailPart.getInputStream());
                    if (LOG.isWarnEnabled() && null != sb) {
                        sb.append(" Using auto-detected encoding: \"").append(cs).append('\"');
                        LOG.warn((Object)sb.toString());
                    }
                } else {
                    cs = MailProperties.getInstance().getDefaultMimeCharset();
                    if (LOG.isWarnEnabled() && null != sb) {
                        sb.append(" Using fallback encoding: \"").append(cs).append('\"');
                        LOG.warn((Object)sb.toString());
                    }
                }
            }
            charset = cs;
        } else {
            charset = contentType.startsWith("text/") ? CharsetDetector.detectCharset((InputStream)mailPart.getInputStream()) : MailProperties.getInstance().getDefaultMimeCharset();
        }
        return charset;
    }

    private TextProcessing() {
    }
}

