/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.text;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.image.ImageLocation;
import com.openexchange.java.AllocatingStringWriter;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.conversion.InlineImageDataSource;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.HashUtility;
import com.openexchange.tools.regex.MatcherReplacer;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class HtmlProcessing {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(HtmlProcessing.class));
    private static final String CHARSET_US_ASCII = "US-ASCII";
    private static final String COMMENT_ID = "anchor-5fd15ca8-a027-4b14-93ea-35de1747419e:";
    private static volatile Boolean useSanitize;
    private static final Pattern PATTERN_HTML;
    private static final Pattern PATTERN_HEAD;
    private static final Pattern PATTERN_BODY;
    private static final Pattern PAT_ATTR_BGCOLOR;
    private static final Pattern PAT_ATTR_STYLE;
    private static final Pattern PATTERN_CSS_CLASS_NAME;
    private static final Pattern PATTERN_HTML_BODY;
    private static final Pattern PATTERN_BODY_TAG;
    private static final Pattern PATTERN_BODY_STYLE;
    private static final Pattern PATTERN_BODY_CLASS;
    private static final Pattern PATTERN_STYLE;
    private static final Pattern PATTERN_STYLE_FILE;
    private static final int INDENT = 2;
    private static final String DEFAULT_COLOR = "#0026ff";
    private static final String BLOCKQUOTE_START_TEMPLATE = "<blockquote type=\"cite\" style=\"margin-left: 0px; margin-right: 0px; padding-left: 10px; color:%s; border-left: solid 1px %s;\">";
    private static final String BLOCKQUOTE_END = "</blockquote>\n";
    private static final String STR_HTML_QUOTE = "&gt;";
    private static final String STR_SPLIT_BR = "<br[ \t]*/?>";
    private static final String HTML_BREAK = "<br>";
    private static final Pattern PAT_STARTS_WITH_QUOTE;
    private static final Pattern BACKGROUND_PATTERN;
    private static final Pattern IMG_PATTERN;
    private static final Pattern CID_PATTERN;
    private static final Pattern FILENAME_PATTERN;
    private static final String STR_SRC = "src=";
    private static final String EVENT_RESTRICTIONS = "\" onmousedown=\"return false;\" oncontextmenu=\"return false;\"";

    public static String formatTextForDisplay(String content, UserSettingMail usm, DisplayMode mode) {
        return HtmlProcessing.formatContentForDisplay(content, null, false, null, null, usm, null, mode, false);
    }

    public static String formatHTMLForDisplay(String content, String charset, Session session, MailPath mailPath, UserSettingMail usm, boolean[] modified, DisplayMode mode, boolean embedded) {
        return HtmlProcessing.formatContentForDisplay(content, charset, true, session, mailPath, usm, modified, mode, embedded);
    }

    public static String formatContentForDisplay(String content, String charset, boolean isHtml, Session session, MailPath mailPath, UserSettingMail usm, boolean[] modified, DisplayMode mode, boolean embedded) {
        String retval = null;
        HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
        if (isHtml) {
            if (DisplayMode.RAW.equals((Object)mode)) {
                retval = content;
            } else {
                retval = htmlService.dropScriptTagsInHeader(content);
                if (DisplayMode.MODIFYABLE.isIncluded(mode) && usm.isDisplayHtmlInlineContent()) {
                    String cssPrefix;
                    boolean externalImagesAllowed = usm.isAllowHTMLImages();
                    retval = htmlService.checkBaseTag(retval, externalImagesAllowed);
                    String string = null == mailPath ? null : (cssPrefix = embedded ? "ox-" + HtmlProcessing.getHash(mailPath.toString(), 10) : null);
                    if (HtmlProcessing.useSanitize()) {
                        retval = externalImagesAllowed ? htmlService.sanitize(retval, null, false, null, cssPrefix) : htmlService.sanitize(retval, null, true, modified, cssPrefix);
                    } else {
                        retval = htmlService.getConformHTML(retval, charset == null ? CHARSET_US_ASCII : charset, false);
                        retval = htmlService.filterWhitelist(retval);
                        if (!externalImagesAllowed) {
                            retval = htmlService.filterExternalImages(retval, modified);
                        }
                    }
                    if (mailPath != null && session != null) {
                        retval = HtmlProcessing.filterInlineImages(retval, session, mailPath);
                    }
                    if (embedded) {
                        retval = HtmlProcessing.replaceBody(retval, cssPrefix);
                    }
                }
            }
        } else {
            retval = content;
            if (DisplayMode.MODIFYABLE.isIncluded(mode)) {
                if (DisplayMode.DISPLAY.equals((Object)mode)) {
                    retval = htmlService.formatURLs(retval, COMMENT_ID);
                    retval = htmlService.htmlFormat(retval, true, COMMENT_ID);
                    if (usm.isUseColorQuote()) {
                        retval = HtmlProcessing.replaceHTMLSimpleQuotesForDisplay(retval);
                    }
                } else {
                    retval = htmlService.htmlFormat(retval);
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean useSanitize() {
        if (null != useSanitize) return useSanitize;
        Class<HtmlProcessing> clazz = HtmlProcessing.class;
        synchronized (HtmlProcessing.class) {
            if (null != useSanitize) return useSanitize;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            useSanitize = null == service || service.getBoolProperty("com.openexchange.mail.text.useSanitize", true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return useSanitize;
        }
    }

    public static String getHash(String str, int maxLen) {
        if (HtmlProcessing.isEmpty(str)) {
            return str;
        }
        if (maxLen <= 0) {
            return HashUtility.getHash(str, "md5", "hex");
        }
        return HtmlProcessing.abbreviate(HashUtility.getHash(str, "md5", "hex"), 0, maxLen);
    }

    private static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length <= maxWidth) {
            return str;
        }
        int off = offset;
        if (off > length) {
            off = length;
        }
        if (length - off < maxWidth) {
            off = length - maxWidth;
        }
        if (off < 1) {
            return str.substring(0, maxWidth);
        }
        if (off + maxWidth < length) {
            return HtmlProcessing.abbreviate(str.substring(off), 0, maxWidth);
        }
        return str.substring(length - maxWidth);
    }

    private static String replaceBody(String htmlContent, String cssPrefix) {
        if (HtmlProcessing.isEmpty(htmlContent) || HtmlProcessing.isEmpty(cssPrefix)) {
            return htmlContent;
        }
        Matcher htmlMatcher = PATTERN_HTML.matcher(htmlContent);
        if (!htmlMatcher.find()) {
            return HtmlProcessing.replaceBodyPlain(htmlContent, cssPrefix);
        }
        Matcher headMatcher = PATTERN_HEAD.matcher(htmlMatcher.group(1));
        if (!headMatcher.find()) {
            return HtmlProcessing.replaceBodyPlain(htmlContent, cssPrefix);
        }
        Matcher bodyMatcher = PATTERN_BODY.matcher(htmlContent);
        if (!bodyMatcher.find()) {
            return HtmlProcessing.replaceBodyPlain(htmlContent, cssPrefix);
        }
        StringAllocator sb = new StringAllocator(htmlContent.length() + 256);
        sb.append("<div id=\"").append(cssPrefix).append('\"');
        String rest = bodyMatcher.group(1);
        if (!HtmlProcessing.isEmpty(rest)) {
            sb.append(' ').append(HtmlProcessing.cleanUpRest(rest));
        }
        sb.append('>');
        Matcher styleMatcher = PATTERN_STYLE.matcher(headMatcher.group(1));
        while (styleMatcher.find()) {
            sb.append(styleMatcher.group());
        }
        sb.append(bodyMatcher.group(2));
        sb.append("</div>");
        int end = bodyMatcher.end();
        if (end < htmlContent.length()) {
            sb.append(htmlContent.substring(end));
        }
        return sb.toString();
    }

    private static String cleanUpRest(String rest) {
        Matcher m = PAT_ATTR_BGCOLOR.matcher(rest);
        if (!m.find()) {
            return rest;
        }
        String color = m.group(1);
        String ret = rest;
        StringBuffer sbuf = new StringBuffer(ret.length());
        m.appendReplacement(sbuf, "");
        m.appendTail(sbuf);
        m = PAT_ATTR_STYLE.matcher(sbuf.toString());
        if (!m.find()) {
            return sbuf.append(" style=\"background-color: ").append(color).append(";\"").toString();
        }
        sbuf.setLength(0);
        m.appendReplacement(sbuf, "style=\"" + Strings.quoteReplacement((String)m.group(1)) + " background-color: " + color + ";\"");
        m.appendTail(sbuf);
        return sbuf.toString();
    }

    private static String replaceBodyPlain(String htmlContent, String cssPrefix) {
        Matcher m = PATTERN_BODY.matcher(htmlContent);
        MatcherReplacer mr = new MatcherReplacer(m, htmlContent);
        StringAllocator sb = new StringAllocator(htmlContent.length() + 256);
        if (m.find()) {
            mr.appendLiteralReplacement(sb, "<div id=\"" + cssPrefix + "\" " + m.group(1) + '>' + m.group(2) + "</div>");
        }
        mr.appendTail(sb);
        return sb.toString();
    }

    public static String saneCss(String htmlContent, HtmlService optHtmlService, String cssPrefix) {
        String retval;
        if (null == htmlContent) {
            return null;
        }
        String css = (optHtmlService == null ? ServerServiceRegistry.getInstance().getService(HtmlService.class) : optHtmlService).getCSSFromHTMLHeader(retval = htmlContent);
        Matcher cssClassMatcher = PATTERN_CSS_CLASS_NAME.matcher(css);
        if (cssClassMatcher.find()) {
            Matcher bodyTagMatcher = PATTERN_BODY_TAG.matcher(retval);
            String className = "";
            String styleName = "";
            if (bodyTagMatcher.find()) {
                String body = bodyTagMatcher.group(1);
                Matcher m = PATTERN_BODY_CLASS.matcher(body);
                if (m.find()) {
                    className = m.group();
                }
                if ((m = PATTERN_BODY_STYLE.matcher(body)).find()) {
                    styleName = m.group();
                }
            }
            StringBuilder tmp = new StringBuilder(64);
            String newCss = css;
            do {
                String cssClass = cssClassMatcher.group();
                tmp.setLength(0);
                newCss = newCss.replace(cssClass, tmp.append('#').append(cssPrefix).append(' ').append(cssClass).toString());
            } while (cssClassMatcher.find());
            tmp.setLength(0);
            newCss = tmp.append("<style>").append(newCss).append("</style>").toString();
            retval = HtmlProcessing.dropStyles(retval);
            Matcher htmlBodyMatcher = PATTERN_HTML_BODY.matcher(retval);
            if (htmlBodyMatcher.find()) {
                tmp.setLength(0);
                retval = tmp.append(newCss).append("<div id=\"").append(cssPrefix).append("\" ").append(className).append(' ').append(styleName).append('>').append(htmlBodyMatcher.group(1)).append("</div>").toString();
            }
        }
        return retval;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    private static String dropStyles(String htmlContent) {
        StringBuffer buf = new StringBuffer(htmlContent.length());
        Matcher matcher = PATTERN_STYLE.matcher(htmlContent);
        while (matcher.find()) {
            matcher.appendReplacement(buf, "");
        }
        matcher.appendTail(buf);
        matcher = PATTERN_STYLE_FILE.matcher(buf.toString());
        buf.setLength(0);
        while (matcher.find()) {
            matcher.appendReplacement(buf, "");
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public static String html2text(String htmlContent, boolean appendHref) {
        return ServerServiceRegistry.getInstance().getService(HtmlService.class).html2text(htmlContent, appendHref);
    }

    public static String formatHrefLinks(String content) {
        return ServerServiceRegistry.getInstance().getService(HtmlService.class).formatHrefLinks(content);
    }

    public static String getConformHTML(String htmlContent, ContentType contentType) {
        return HtmlProcessing.getConformHTML(htmlContent, contentType.getCharsetParameter());
    }

    public static String getConformHTML(String htmlContent, String charset) {
        return ServerServiceRegistry.getInstance().getService(HtmlService.class).getConformHTML(htmlContent, charset);
    }

    public static Document createDOMDocument(String string) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String prettyPrintXML(String string) {
        return HtmlProcessing.prettyPrintXML(HtmlProcessing.createDOMDocument(string), string);
    }

    public static String prettyPrintXML(Node node) {
        return HtmlProcessing.prettyPrintXML(node, null);
    }

    private static String prettyPrintXML(Node node, String fallback) {
        if (null == node) {
            return fallback;
        }
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            tfactory.setAttribute("indent-number", new Integer(2));
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(2));
            AllocatingStringWriter sw = new AllocatingStringWriter();
            serializer.transform(new DOMSource(node), new StreamResult((Writer)sw));
            return sw.toString();
        }
        catch (TransformerException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return fallback;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return fallback;
        }
    }

    public static String prettyPrint(String htmlContent) {
        return ServerServiceRegistry.getInstance().getService(HtmlService.class).prettyPrint(htmlContent);
    }

    public static String replaceHTMLEntities(String content) {
        return ServerServiceRegistry.getInstance().getService(HtmlService.class).replaceHTMLEntities(content);
    }

    public static Character getHTMLEntity(String entity) {
        return ServerServiceRegistry.getInstance().getService(HtmlService.class).getHTMLEntity(entity);
    }

    public static String htmlFormat(String plainText, boolean withQuote) {
        return ServerServiceRegistry.getInstance().getService(HtmlService.class).htmlFormat(plainText, withQuote);
    }

    public static String htmlFormat(String plainText) {
        return ServerServiceRegistry.getInstance().getService(HtmlService.class).htmlFormat(plainText);
    }

    private static String getLevelColor(int quotelevel) {
        String[] colors = MailProperties.getInstance().getQuoteLineColors();
        return colors != null && colors.length > 0 ? (quotelevel >= colors.length ? colors[colors.length - 1] : colors[quotelevel]) : DEFAULT_COLOR;
    }

    private static String replaceHTMLSimpleQuotesForDisplay(String htmlText) {
        StringAllocator sb = new StringAllocator(htmlText.length());
        String[] lines = htmlText.split(STR_SPLIT_BR);
        int levelBefore = 0;
        int llen = lines.length - 1;
        for (int i = 0; i <= llen; ++i) {
            String line = lines[i];
            int currentLevel = 0;
            int offset = 0;
            offset = HtmlProcessing.startsWithQuote(line);
            if (offset != -1) {
                ++currentLevel;
                int pos = -1;
                boolean next = true;
                while (next && (pos = line.indexOf(STR_HTML_QUOTE, offset)) > -1) {
                    next = offset == pos || pos - offset == 1 && Strings.isWhitespace((char)line.charAt(offset));
                    if (!next) continue;
                    ++currentLevel;
                    offset = pos + 4;
                }
            }
            if (offset > 0) {
                block11: {
                    try {
                        offset = offset < line.length() && Strings.isWhitespace((char)line.charAt(offset)) ? offset + 1 : offset;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        if (!LOG.isTraceEnabled()) break block11;
                        LOG.trace((Object)e.getMessage(), (Throwable)e);
                    }
                }
                line = line.substring(offset);
            }
            if (levelBefore < currentLevel) {
                while (levelBefore < currentLevel) {
                    String color = HtmlProcessing.getLevelColor(levelBefore);
                    sb.append(String.format(BLOCKQUOTE_START_TEMPLATE, color, color));
                    ++levelBefore;
                }
            } else if (levelBefore > currentLevel) {
                while (levelBefore > currentLevel) {
                    sb.append(BLOCKQUOTE_END);
                    --levelBefore;
                }
            }
            sb.append(line);
            if (i >= llen) continue;
            sb.append(HTML_BREAK);
        }
        return sb.toString();
    }

    private static int startsWithQuote(String str) {
        Matcher m = PAT_STARTS_WITH_QUOTE.matcher(str);
        if (m.find() && m.start() == 0) {
            return m.end();
        }
        return -1;
    }

    public static String filterInlineImages(String content, Session session, MailPath msgUID) {
        String ret = HtmlProcessing.filterImgInlineImages(content, session, msgUID);
        ret = HtmlProcessing.filterBackgroundInlineImages(ret, session, msgUID);
        return ret;
    }

    private static String filterBackgroundInlineImages(String content, Session session, MailPath msgUID) {
        String reval = content;
        try {
            Matcher imgMatcher = BACKGROUND_PATTERN.matcher(reval);
            MatcherReplacer imgReplacer = new MatcherReplacer(imgMatcher, reval);
            StringAllocator sb = new StringAllocator(reval.length());
            if (imgMatcher.find()) {
                StringBuilder linkBuilder = new StringBuilder(256);
                do {
                    String cid;
                    if ((cid = imgMatcher.group(2)) == null) {
                        cid = imgMatcher.group(3);
                    }
                    InlineImageDataSource imgSource = InlineImageDataSource.getInstance();
                    ImageLocation imageLocation = new ImageLocation.Builder(cid).folder(MailFolderUtility.prepareFullname(msgUID.getAccountId(), msgUID.getFolder())).id(msgUID.getMailID()).build();
                    String imageURL = imgSource.generateUrl(imageLocation, session);
                    linkBuilder.setLength(0);
                    linkBuilder.append(imgMatcher.group(1)).append("background=\"").append(imageURL).append(EVENT_RESTRICTIONS).append(imgMatcher.group(4));
                    imgReplacer.appendLiteralReplacement(sb, linkBuilder.toString());
                } while (imgMatcher.find());
            }
            imgReplacer.appendTail(sb);
            reval = sb.toString();
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to filter cid background images: " + e.getMessage()));
        }
        return reval;
    }

    private static String filterImgInlineImages(String content, Session session, MailPath msgUID) {
        String reval = content;
        try {
            Matcher imgMatcher = IMG_PATTERN.matcher(reval);
            MatcherReplacer imgReplacer = new MatcherReplacer(imgMatcher, reval);
            StringAllocator sb = new StringAllocator(reval.length());
            if (imgMatcher.find()) {
                StringBuilder strBuffer = new StringBuilder(256);
                MatcherReplacer mr = new MatcherReplacer();
                StringBuilder linkBuilder = new StringBuilder(256);
                do {
                    String imgTag;
                    if (!HtmlProcessing.replaceImgSrc(session, msgUID, imgTag = imgMatcher.group(), strBuffer, linkBuilder)) {
                        strBuffer.setLength(0);
                        Matcher m = FILENAME_PATTERN.matcher(imgTag);
                        mr.resetTo(m, imgTag);
                        if (m.find()) {
                            String filename = m.group(1);
                            InlineImageDataSource imgSource = InlineImageDataSource.getInstance();
                            ImageLocation imageLocation = new ImageLocation.Builder(filename).folder(MailFolderUtility.prepareFullname(msgUID.getAccountId(), msgUID.getFolder())).id(msgUID.getMailID()).build();
                            String imageURL = imgSource.generateUrl(imageLocation, session);
                            linkBuilder.setLength(0);
                            linkBuilder.append(STR_SRC).append('\"').append(imageURL).append('\"').append(" id=\"").append(filename).append(EVENT_RESTRICTIONS);
                            mr.appendLiteralReplacement(strBuffer, linkBuilder.toString());
                        }
                        mr.appendTail(strBuffer);
                    }
                    imgReplacer.appendLiteralReplacement(sb, strBuffer.toString());
                    strBuffer.setLength(0);
                } while (imgMatcher.find());
            }
            imgReplacer.appendTail(sb);
            reval = sb.toString();
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to filter cid Images: " + e.getMessage()));
        }
        return reval;
    }

    private static boolean replaceImgSrc(Session session, MailPath msgUID, String imgTag, StringBuilder cidBuffer, StringBuilder linkBuilder) throws OXException {
        boolean retval = false;
        Matcher cidMatcher = CID_PATTERN.matcher(imgTag);
        MatcherReplacer cidReplacer = new MatcherReplacer(cidMatcher, imgTag);
        if (cidMatcher.find()) {
            retval = true;
            do {
                String tmp;
                int unifiedINBOXAccountID;
                String cid;
                if ((cid = cidMatcher.group(2)) == null) {
                    cid = cidMatcher.group(1);
                }
                InlineImageDataSource imgSource = InlineImageDataSource.getInstance();
                String mailId = msgUID.getMailID();
                if (mailId.indexOf(37) >= 0 && ((unifiedINBOXAccountID = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class).getUnifiedINBOXAccountID(session)) < 0 || msgUID.getAccountId() != unifiedINBOXAccountID) && (tmp = AJAXServlet.decodeUrl(mailId, null)).startsWith("default")) {
                    try {
                        mailId = new MailPath(tmp).getMailID();
                    }
                    catch (OXException e) {
                        // empty catch block
                    }
                }
                ImageLocation imageLocation = new ImageLocation.Builder(cid).folder(MailFolderUtility.prepareFullname(msgUID.getAccountId(), msgUID.getFolder())).id(mailId).build();
                String imageURL = imgSource.generateUrl(imageLocation, session);
                linkBuilder.setLength(0);
                linkBuilder.append(STR_SRC).append('\"').append(imageURL).append('\"').append(" id=\"").append(cid).append(EVENT_RESTRICTIONS);
                cidReplacer.appendLiteralReplacement(cidBuffer, linkBuilder.toString());
            } while (cidMatcher.find());
        }
        cidReplacer.appendTail(cidBuffer);
        return retval;
    }

    public static String urlEncodeSafe(String text, String charset) {
        try {
            return URLEncoder.encode(text, charset);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return text;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void dumpToFile(String content, String fileName) {
        if (HtmlProcessing.isEmpty(content)) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Streams.close((Closeable)writer);
        }
        catch (RuntimeException e2) {
            LOG.error((Object)e2.getMessage(), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    Streams.close(writer);
                    throw throwable;
                }
            }
            Streams.close((Closeable)writer);
        }
        Streams.close((Closeable)writer);
    }

    private HtmlProcessing() {
    }

    static {
        PATTERN_HTML = Pattern.compile("<html.*?>(.*?)</html>", 34);
        PATTERN_HEAD = Pattern.compile("<head.*?>(.*?)</head>", 34);
        PATTERN_BODY = Pattern.compile("<body(.*?)>(.*?)</body>", 34);
        PAT_ATTR_BGCOLOR = Pattern.compile("bgcolor=\"([^\"]+)\"", 2);
        PAT_ATTR_STYLE = Pattern.compile("style=\"([^\"]+)\"", 2);
        PATTERN_CSS_CLASS_NAME = Pattern.compile("\\s?\\.[a-zA-Z0-9\\s:,\\.#_-]*\\s*\\{.*?\\}", 34);
        PATTERN_HTML_BODY = Pattern.compile("<body.*?>(.*?)</body>", 34);
        PATTERN_BODY_TAG = Pattern.compile("(<body.*?>)", 34);
        PATTERN_BODY_STYLE = Pattern.compile("(style=[\"].*?[\"]|style=['].*?['])", 2);
        PATTERN_BODY_CLASS = Pattern.compile("(class=[\"].*?[\"]|class=['].*?['])", 2);
        PATTERN_STYLE = Pattern.compile("<style.*?>.*?</style>", 34);
        PATTERN_STYLE_FILE = Pattern.compile("<link.*?(type=['\"]text/css['\"].*?href=['\"](.*?)['\"]|href=['\"](.*?)['\"].*?type=['\"]text/css['\"]).*?/>", 34);
        PAT_STARTS_WITH_QUOTE = Pattern.compile("\\s*&gt;\\s*", 2);
        BACKGROUND_PATTERN = Pattern.compile("(<[a-zA-Z]+[^>]*?)(?:(?:background=cid:([^\\s>]*))|(?:background=\"cid:([^\"]*)\"))([^>]*/?>)", 34);
        IMG_PATTERN = Pattern.compile("<img[^>]*>", 34);
        CID_PATTERN = Pattern.compile("(?:src=cid:([^\\s>]*))|(?:src=\"cid:([^\"]*)\")", 34);
        FILENAME_PATTERN = Pattern.compile("src=\"?([0-9a-z&&[^.\\s>\"]]+\\.[0-9a-z&&[^.\\s>\"]]+)\"?", 2);
    }
}

