/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.log.Log;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.IcsMimeFilter;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.utils.MessageUtility;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;

public class MimeFilter {
    private static final String MESSAGE_ID = "Message-ID";
    private static final String CONTENT_TYPE = "Content-Type";
    protected final List<String> ignorableContentTypes;

    public static MimeFilter filterFor(String alias) {
        if ("ics".equalsIgnoreCase(alias)) {
            return IcsMimeFilter.getInstance();
        }
        return null;
    }

    public static MimeFilter filterFor(String ... ignorableContentTypes) {
        return new MimeFilter(Arrays.asList(ignorableContentTypes));
    }

    public static MimeFilter filterFor(List<String> ignorableContentTypes) {
        return new MimeFilter(ignorableContentTypes);
    }

    protected MimeFilter(List<String> ignorableContentTypes) {
        this.ignorableContentTypes = ignorableContentTypes;
    }

    public List<String> getIgnorableContentTypes() {
        return this.ignorableContentTypes;
    }

    public MimeMessage filter(MimeMessage mimeMessage) throws OXException {
        if (null == mimeMessage) {
            return null;
        }
        try {
            String messageId = mimeMessage.getHeader(MESSAGE_ID, null);
            String contentType = MimeFilter.toLowerCase(mimeMessage.getContentType());
            if (!contentType.startsWith("multipart/")) {
                return mimeMessage;
            }
            MimeMultipart newMultipart = new MimeMultipart(MimeFilter.getSubType(contentType, "mixed"));
            this.handlePart(this.getMultipartContent(mimeMessage), newMultipart);
            MessageUtility.setContent((Multipart)newMultipart, (Part)mimeMessage);
            MimeMessageConverter.saveChanges(mimeMessage);
            if (null == messageId) {
                mimeMessage.removeHeader(MESSAGE_ID);
            } else {
                mimeMessage.setHeader(MESSAGE_ID, messageId);
            }
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private Multipart getMultipartContent(MimeMessage mimeMessage) throws IOException, MessagingException, ParseException {
        try {
            return (Multipart)mimeMessage.getContent();
        }
        catch (ParseException e) {
            try {
                String sContentType = mimeMessage.getHeader(CONTENT_TYPE, null);
                mimeMessage.setHeader(CONTENT_TYPE, new ContentType(sContentType).toString(true));
                MimeMessageConverter.saveChanges(mimeMessage);
            }
            catch (Exception x) {
                Log.loggerFor(MimeFilter.class).debug((Object)"Content-Type cannot be sanitized.", (Throwable)x);
                throw e;
            }
            return (Multipart)mimeMessage.getContent();
        }
    }

    public boolean ignorable(String contentType, BodyPart bodyPart) {
        for (String baseType : this.ignorableContentTypes) {
            if (!contentType.startsWith(baseType)) continue;
            return true;
        }
        return false;
    }

    public boolean ignorable(String contentType, MailPart bodyPart) {
        for (String baseType : this.ignorableContentTypes) {
            if (!contentType.startsWith(baseType)) continue;
            return true;
        }
        return false;
    }

    private void handlePart(Multipart multipart, MimeMultipart newMultipart) throws MessagingException, IOException, OXException {
        int count = multipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            String contentType = bodyPart.getContentType();
            String name = new ContentType(contentType).getNameParameter();
            if (MimeFilter.isEmpty(contentType)) {
                newMultipart.addBodyPart(bodyPart);
                continue;
            }
            if ((contentType = MimeFilter.toLowerCase(contentType.trim())).startsWith("multipart/")) {
                MimeMultipart newSubMultipart = new MimeMultipart(MimeFilter.getSubType(contentType, "mixed"));
                Object content = bodyPart.getContent();
                if (content instanceof Multipart) {
                    this.handlePart((Multipart)content, newSubMultipart);
                } else {
                    this.handlePart((Multipart)new MimeMultipart(bodyPart.getDataHandler().getDataSource()), newSubMultipart);
                }
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                MessageUtility.setContent((Multipart)newSubMultipart, (Part)mimeBodyPart);
                newMultipart.addBodyPart((BodyPart)mimeBodyPart);
                continue;
            }
            if (contentType.startsWith("message/rfc822") || name != null && name.endsWith(".eml")) {
                MimeFilter nestedFilter = new MimeFilter(this.ignorableContentTypes);
                Object content = bodyPart.getContent();
                MimeMessage filteredMessage = content instanceof MimeMessage ? nestedFilter.filter((MimeMessage)content) : nestedFilter.filter(new MimeMessage(MimeDefaultSession.getDefaultSession(), bodyPart.getInputStream()));
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                MessageUtility.setContent((Message)filteredMessage, (Part)mimeBodyPart);
                newMultipart.addBodyPart((BodyPart)mimeBodyPart);
                continue;
            }
            if (this.ignorable(contentType, bodyPart)) continue;
            newMultipart.addBodyPart(bodyPart);
        }
    }

    private static String getSubType(String contentType, String defaultType) {
        try {
            return new ContentType(contentType).getSubType();
        }
        catch (Exception e) {
            return defaultType;
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }
}

