/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.osgi;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXResultDecorator;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.osgiservice.AJAXModuleActivator;
import com.openexchange.contact.ContactService;
import com.openexchange.contact.SortOptions;
import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.datasource.ContactImageDataSource;
import com.openexchange.groupware.contact.datasource.UserImageDataSource;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.image.ImageLocation;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailActionFactory;
import com.openexchange.mail.json.converters.MailConverter;
import com.openexchange.mail.json.converters.MailJSONConverter;
import com.openexchange.server.ExceptionOnAbsenceServiceLookup;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.concurrent.atomic.AtomicReference;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MailJSONActivator
extends AJAXModuleActivator {
    protected static final Log LOG = com.openexchange.log.Log.loggerFor(MailJSONActivator.class);
    public static final AtomicReference<ServiceLookup> SERVICES = new AtomicReference();

    protected Class<?>[] getNeededServices() {
        return new Class[]{ContactService.class, ContactStorage.class};
    }

    protected void startBundle() throws Exception {
        ExceptionOnAbsenceServiceLookup serviceLookup = new ExceptionOnAbsenceServiceLookup((ServiceLookup)this);
        SERVICES.set((ServiceLookup)serviceLookup);
        this.registerModule(new MailActionFactory((ServiceLookup)serviceLookup), "mail");
        MailConverter converter = MailConverter.getInstance();
        this.registerService(ResultConverter.class, converter);
        this.registerService(ResultConverter.class, new MailJSONConverter(converter));
        ContactField[] fields = new ContactField[]{ContactField.OBJECT_ID, ContactField.INTERNAL_USERID, ContactField.FOLDER_ID, ContactField.NUMBER_OF_IMAGES};
        this.registerService(AJAXResultDecorator.class, new DecoratorImpl(converter, fields));
    }

    protected void stopBundle() throws Exception {
        super.stopBundle();
        SERVICES.set(null);
    }

    private final class DecoratorImpl
    implements AJAXResultDecorator {
        private final MailConverter converter;
        private final ContactField[] fields;

        protected DecoratorImpl(MailConverter converter, ContactField[] fields) {
            this.converter = converter;
            this.fields = fields;
        }

        @Override
        public String getIdentifier() {
            return "mail.senderImageUrl";
        }

        @Override
        public String getFormat() {
            return "mail";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void decorate(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
            Object resultObject = result.getResultObject();
            if (null == resultObject) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Result object is null.");
                }
                result.setResultObject(JSONObject.NULL, "json");
                return;
            }
            String action = requestData.getAction();
            if ("get".equals(action) && resultObject instanceof MailMessage) {
                try {
                    MailMessage mailMessage = (MailMessage)resultObject;
                    InternetAddress[] from = mailMessage.getFrom();
                    if (null == from || 0 == from.length) {
                        return;
                    }
                    SearchIterator<Contact> searchIterator = null;
                    String imageURL = null;
                    try {
                        searchIterator = ((ContactService)MailJSONActivator.this.getService(ContactService.class)).searchContacts((Session)session, this.createContactSearchObject(from[0]), this.fields, new SortOptions(ContactField.FOLDER_ID, Order.ASCENDING));
                        if (null != searchIterator) {
                            while (null == imageURL && searchIterator.hasNext()) {
                                Contact contact = (Contact)searchIterator.next();
                                imageURL = this.getImageURL(session, contact);
                            }
                        }
                    }
                    finally {
                        if (null != searchIterator) {
                            searchIterator.close();
                        }
                    }
                    this.converter.convert2JSON(requestData, result, session);
                    JSONArray fromImageURLs = new JSONArray();
                    if (null != imageURL) {
                        fromImageURLs.put((Object)imageURL);
                    }
                    ((JSONObject)result.getResultObject()).put("from_image_urls", (Object)fromImageURLs);
                }
                catch (JSONException e) {
                    throw OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]);
                }
            }
        }

        private String getImageURL(ServerSession session, Contact contact) {
            block4: {
                if (0 < contact.getNumberOfImages() || contact.containsImage1() && null != contact.getImage1()) {
                    String timestamp = null != contact.getLastModified() ? String.valueOf(contact.getLastModified().getTime()) : null;
                    try {
                        if (6 == contact.getParentFolderID() && contact.containsInternalUserId()) {
                            ImageLocation imageLocation = new ImageLocation.Builder().id(String.valueOf(contact.getInternalUserId())).timestamp(timestamp).build();
                            return UserImageDataSource.getInstance().generateUrl(imageLocation, session);
                        }
                        ImageLocation imageLocation = new ImageLocation.Builder().folder(String.valueOf(contact.getParentFolderID())).id(String.valueOf(contact.getObjectID())).timestamp(timestamp).build();
                        return ContactImageDataSource.getInstance().generateUrl(imageLocation, session);
                    }
                    catch (OXException e) {
                        if (!LOG.isWarnEnabled()) break block4;
                        LOG.warn((Object)"Error generating contact image URL", (Throwable)e);
                    }
                }
            }
            return null;
        }

        private ContactSearchObject createContactSearchObject(InternetAddress from) {
            ContactSearchObject searchObject = new ContactSearchObject();
            searchObject.setOrSearch(true);
            String address = from.getAddress();
            searchObject.setEmail1(address);
            searchObject.setEmail2(address);
            searchObject.setEmail3(address);
            return searchObject;
        }
    }
}

