/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.parser.SearchTermParser;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.writer.MessageWriter;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

@Action(method=RequestMethod.PUT, name="search", description="Search mails", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="Object ID of the folder, whose contents are queried."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for appointments are defined in Detailed mail data."), @Parameter(name="sort", optional=true, description="The identifier of a column which determines the sort order of the response or the string \"thread\" to return thread-sorted messages. If this parameter is specified and holds a column number, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified.")}, requestBody="A JSON array of JSON objects each containing the search field and its search pattern: e.g.: [{\"col\": 612, \"pattern\": \"Joe\"}, {\"col\": 614, \"pattern\": \"Tuesday\"}] Supported values for col are 603 to 607 (from, to, cc, bcc and subject) and -1 for full text search.", responseDescription="(not IMAP: with timestamp): An array with mail data. Each array element describes one mail and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public final class SearchAction
extends AbstractMailAction {
    public SearchAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            AJAXRequestResult result;
            ServerSession session = req.getSession();
            String folderId = req.checkParameter("folder");
            int[] columns = req.checkIntArray("columns");
            String sort = req.getParameter("sort");
            String order = req.getParameter("order");
            if (sort != null && order == null) {
                throw MailExceptionCode.MISSING_PARAM.create("order");
            }
            boolean ignoreDeleted = !req.optBool("deleted", true);
            String stz = req.getParameter("timezone");
            TimeZone timeZone = SearchAction.isEmpty(stz) ? null : TimeZoneUtils.getTimeZone(stz.trim());
            stz = null;
            JSONValue searchValue = (JSONValue)req.getRequest().requireData();
            MailServletInterface mailInterface = this.getMailInterface(req);
            if (searchValue.isArray()) {
                JSONArray ja = searchValue.toArray();
                int length = ja.length();
                if (length > 0) {
                    int[] searchCols = new int[length];
                    String[] searchPats = new String[length];
                    for (int i = 0; i < length; ++i) {
                        JSONObject tmp = ja.getJSONObject(i);
                        searchCols[i] = tmp.getInt("col");
                        searchPats[i] = tmp.getString("pattern");
                    }
                    MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
                    int userId = session.getUserId();
                    int contextId = session.getContextId();
                    int orderDir = OrderDirection.ASC.getOrder();
                    if (order != null) {
                        if (order.equalsIgnoreCase("asc")) {
                            orderDir = OrderDirection.ASC.getOrder();
                        } else if (order.equalsIgnoreCase("desc")) {
                            orderDir = OrderDirection.DESC.getOrder();
                        } else {
                            throw MailExceptionCode.INVALID_INT_VALUE.create("order");
                        }
                    }
                    OXJSONWriter jsonWriter = new OXJSONWriter();
                    jsonWriter.array();
                    SearchIterator<MailMessage> it = null;
                    try {
                        if ("thread".equalsIgnoreCase(sort)) {
                            it = mailInterface.getThreadedMessages(folderId, null, MailSortField.RECEIVED_DATE.getField(), orderDir, searchCols, searchPats, true, columns);
                            int size = it.size();
                            for (int i = 0; i < size; ++i) {
                                MailMessage mail = (MailMessage)it.next();
                                if (mail == null || ignoreDeleted && mail.isDeleted()) continue;
                                JSONArray arr = new JSONArray();
                                for (MessageWriter.MailFieldWriter writer : writers) {
                                    writer.writeField((JSONValue)arr, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                                }
                                jsonWriter.value(arr);
                            }
                        } else {
                            int sortCol = sort == null ? MailListField.RECEIVED_DATE.getField() : Integer.parseInt(sort);
                            it = mailInterface.getMessages(folderId, null, sortCol, orderDir, searchCols, searchPats, true, columns);
                            int size = it.size();
                            for (int i = 0; i < size; ++i) {
                                MailMessage mail = (MailMessage)it.next();
                                if (mail == null || ignoreDeleted && mail.isDeleted()) continue;
                                JSONArray arr = new JSONArray();
                                for (MessageWriter.MailFieldWriter writer : writers) {
                                    writer.writeField((JSONValue)arr, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                                }
                                jsonWriter.value(arr);
                            }
                        }
                    }
                    finally {
                        if (it != null) {
                            it.close();
                        }
                    }
                    jsonWriter.endArray();
                    result = new AJAXRequestResult((Object)jsonWriter.getObject(), "json");
                } else {
                    result = new AJAXRequestResult((Object)new JSONArray(0), "json");
                }
            } else {
                JSONArray searchArray = searchValue.toObject().getJSONArray("filter");
                MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
                int userId = session.getUserId();
                int contextId = session.getContextId();
                int orderDir = OrderDirection.ASC.getOrder();
                if (order != null) {
                    if (order.equalsIgnoreCase("asc")) {
                        orderDir = OrderDirection.ASC.getOrder();
                    } else if (order.equalsIgnoreCase("desc")) {
                        orderDir = OrderDirection.DESC.getOrder();
                    } else {
                        throw MailExceptionCode.INVALID_INT_VALUE.create("order");
                    }
                }
                int sortCol = sort == null ? MailListField.RECEIVED_DATE.getField() : Integer.parseInt(sort);
                SearchIterator<MailMessage> it = mailInterface.getMessages(folderId, null, sortCol, orderDir, SearchTermParser.parse(searchArray), true, columns);
                int size = it.size();
                OXJSONWriter jsonWriter = new OXJSONWriter();
                jsonWriter.array();
                for (int i = 0; i < size; ++i) {
                    MailMessage mail = (MailMessage)it.next();
                    if (mail == null || ignoreDeleted && mail.isDeleted()) continue;
                    JSONArray arr = new JSONArray();
                    for (MessageWriter.MailFieldWriter writer : writers) {
                        writer.writeField((JSONValue)arr, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                    }
                    jsonWriter.value(arr);
                }
                jsonWriter.endArray();
                result = new AJAXRequestResult((Object)jsonWriter.getObject(), "json");
            }
            return result;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

