/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.AddUUIDForUserAttributeTable;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MakeUUIDPrimaryForUserAttributeTable
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        ProgressState progress = params.getProgressState();
        Connection con = Database.getNoTimeout(params.getContextId(), true);
        try {
            DBUtils.startTransaction(con);
            progress.setTotal(MakeUUIDPrimaryForUserAttributeTable.getTotalRows(con));
            if (!Tools.columnExists(con, "user_attribute", "uuid")) {
                throw UpdateExceptionCodes.COLUMN_NOT_FOUND.create("uuid");
            }
            AddUUIDForUserAttributeTable.fillUUIDs(con, progress);
            Tools.modifyColumns(con, "user_attribute", new Column("uuid", "BINARY(16) NOT NULL"));
            Tools.createPrimaryKey(con, "user_attribute", new String[]{"cid", "uuid"});
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(params.getContextId(), true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{AddUUIDForUserAttributeTable.class.getName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getTotalRows(Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        int rows = 0;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM user_attribute WHERE uuid IS NULL");
            while (rs.next()) {
                rows += rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return rows;
    }
}

