/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.AddUUIDForDListTables;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MakeUUIDPrimaryForDListTables
extends UpdateTaskAdapter {
    private static final String TABLE = "prg_dlist";
    private static final String DEL_TABLE = "del_dlist";
    private static final String COLUMN = "uuid";

    @Override
    public void perform(PerformParameters params) throws OXException {
        ProgressState progress = params.getProgressState();
        Connection connection = Database.getNoTimeout(params.getContextId(), true);
        try {
            DBUtils.startTransaction(connection);
            progress.setTotal(this.getTotalRows(connection));
            if (!Tools.columnExists(connection, TABLE, COLUMN)) {
                throw UpdateExceptionCodes.COLUMN_NOT_FOUND.create(COLUMN, TABLE);
            }
            if (!Tools.columnExists(connection, DEL_TABLE, COLUMN)) {
                throw UpdateExceptionCodes.COLUMN_NOT_FOUND.create(COLUMN, DEL_TABLE);
            }
            AddUUIDForDListTables.fillUUIDs(connection, TABLE, progress);
            AddUUIDForDListTables.fillUUIDs(connection, DEL_TABLE, progress);
            Tools.modifyColumns(connection, TABLE, new Column(COLUMN, "BINARY(16) NOT NULL"));
            Tools.createPrimaryKey(connection, TABLE, new String[]{COLUMN, "cid", "intfield01"});
            Tools.modifyColumns(connection, DEL_TABLE, new Column(COLUMN, "BINARY(16) NOT NULL"));
            Tools.createPrimaryKey(connection, DEL_TABLE, new String[]{COLUMN, "cid", "intfield01"});
            connection.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(connection);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(connection);
            Database.backNoTimeout(params.getContextId(), true, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalRows(Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        Statement stmt2 = null;
        ResultSet rs2 = null;
        int rows = 0;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM prg_dlist WHERE uuid IS NULL");
            while (rs.next()) {
                rows += rs.getInt(1);
            }
            stmt2 = con.createStatement();
            rs2 = stmt.executeQuery("SELECT COUNT(*) FROM del_dlist WHERE uuid IS NULL");
            while (rs2.next()) {
                rows += rs2.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            DBUtils.closeSQLStuff(rs2, stmt2);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        DBUtils.closeSQLStuff(rs2, stmt2);
        return rows;
    }

    @Override
    public String[] getDependencies() {
        return new String[]{"com.openexchange.groupware.update.tasks.AddUUIDForDListTables"};
    }
}

