/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InfostoreRenamePersonalInfostoreFolders
implements UpdateTask {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(InfostoreRenamePersonalInfostoreFolders.class));

    @Override
    public int addedWithVersion() {
        return 8;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        try {
            List<NameCollision> collisions = NameCollision.getCollisions(contextId, this.getParentFolder());
            for (NameCollision collision : collisions) {
                collision.resolve();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Error resolving name collisions: ", (Throwable)e);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
    }

    protected int getParentFolder() {
        return 9;
    }

    private static final class NameCollision {
        private final String name;
        private final int contextId;
        private int nameCount = 1;

        public NameCollision(String name, int contextId) {
            this.name = name;
            this.contextId = contextId;
        }

        public void resolve() throws SQLException, OXException {
            LOG.info((Object)String.format("Resolving name collisions for folders named %s in context %d", this.name, this.contextId));
            Connection writeCon = null;
            Statement stmt = null;
            Statement checkAvailable = null;
            ResultSet rs = null;
            try {
                writeCon = Database.get(this.contextId, true);
                writeCon.setAutoCommit(false);
                stmt = writeCon.prepareStatement("UPDATE oxfolder_tree SET fname = ? WHERE cid = ? and fuid = ?");
                stmt.setInt(2, this.contextId);
                checkAvailable = writeCon.prepareStatement("SELECT 1 FROM oxfolder_tree WHERE cid = ? AND fname = ?");
                checkAvailable.setInt(1, this.contextId);
                List<Integer> rename = this.discoverIds(writeCon);
                for (int id : rename) {
                    String newName = String.format("%s (%d)", this.name, this.nameCount++);
                    boolean free = false;
                    while (!free) {
                        checkAvailable.setString(2, newName);
                        rs = checkAvailable.executeQuery();
                        free = !rs.next();
                        rs.close();
                        rs = null;
                        if (free) continue;
                        newName = String.format("%s (%d)", this.name, this.nameCount++);
                    }
                    stmt.setString(1, newName);
                    stmt.setInt(3, id);
                    stmt.executeUpdate();
                }
                writeCon.commit();
            }
            catch (SQLException x) {
                try {
                    writeCon.rollback();
                }
                catch (SQLException x2) {
                    LOG.error((Object)"Can't execute rollback.", (Throwable)x2);
                }
                throw x;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException x) {
                        LOG.warn((Object)"Couldn't close statement", (Throwable)x);
                    }
                }
                if (checkAvailable != null) {
                    try {
                        checkAvailable.close();
                    }
                    catch (SQLException x) {
                        LOG.warn((Object)"Couldn't close statement", (Throwable)x);
                    }
                }
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException x) {
                        LOG.warn((Object)"Couldn't close result set", (Throwable)x);
                    }
                }
                if (writeCon != null) {
                    try {
                        writeCon.setAutoCommit(true);
                    }
                    catch (SQLException x) {
                        LOG.warn((Object)"Can't reset auto commit", (Throwable)x);
                    }
                    if (writeCon != null) {
                        Database.back(this.contextId, true, writeCon);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Integer> discoverIds(Connection writeCon) throws SQLException {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            ArrayList<Integer> ids = new ArrayList<Integer>();
            try {
                stmt = writeCon.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid = ? and fname = ?");
                stmt.setInt(1, this.contextId);
                stmt.setString(2, this.name);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ids.add(rs.getInt(1));
                }
            }
            finally {
                if (null != stmt) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException x) {
                        LOG.warn((Object)"Couldn't close statement:", (Throwable)x);
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException x) {
                        LOG.warn((Object)"Couldn't close result set:", (Throwable)x);
                    }
                }
            }
            Collections.sort(ids);
            ids.remove(ids.size() - 1);
            return ids;
        }

        public String getName() {
            return this.name;
        }

        public int getContextId() {
            return this.contextId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static List<NameCollision> getCollisions(int contextId, int parentFolder) throws SQLException, OXException {
            ArrayList<NameCollision> c = new ArrayList<NameCollision>();
            Connection writeCon = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                writeCon = Database.get(contextId, true);
                if (parentFolder == -1) {
                    stmt = writeCon.prepareStatement("SELECT fname, cid  FROM oxfolder_tree WHERE module = ? GROUP BY fname,cid,parent HAVING count(*) > 1");
                    stmt.setInt(1, 8);
                } else {
                    stmt = writeCon.prepareStatement("SELECT fname, cid  FROM oxfolder_tree WHERE module = ? and parent = ? GROUP BY fname,cid,parent HAVING count(*) > 1");
                    stmt.setInt(1, 8);
                    stmt.setInt(2, parentFolder);
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    NameCollision nc = new NameCollision(rs.getString(1), rs.getInt(2));
                    c.add(nc);
                }
                rs.close();
                rs = null;
                ArrayList<NameCollision> arrayList = c;
                return arrayList;
            }
            finally {
                if (null != stmt) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException x) {
                        LOG.warn((Object)"Couldn't close statement", (Throwable)x);
                    }
                }
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException x) {
                        LOG.warn((Object)"Couldn't close result set", (Throwable)x);
                    }
                }
                if (null != writeCon) {
                    Database.backAfterReading(contextId, writeCon);
                }
            }
        }
    }
}

