/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class ExtendCalendarForIMIPHandlingTask
extends UpdateTaskAdapter {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ExtendCalendarForIMIPHandlingTask.class));
    private final String[] TABLES = new String[]{"prg_dates", "del_dates"};
    private final Column[] COLUMNS = new Column[]{new Column("uid", "VARCHAR(255)"), new Column("organizer", "VARCHAR(255)"), new Column("sequence", "INT4 UNSIGNED")};
    private static final String DATES_EXTERNAL_CREATE = "CREATE TABLE dateExternal (cid INT4 UNSIGNED NOT NULL,objectId INT4 UNSIGNED NOT NULL,mailAddress VARCHAR(255) NOT NULL,displayName VARCHAR(255),confirm INT4 UNSIGNED NOT NULL,reason VARCHAR(255),PRIMARY KEY (cid,objectId,mailAddress),FOREIGN KEY (cid,objectId) REFERENCES prg_dates(cid,intfield01)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    private static final String DELDATES_EXTERNAL_CREATE = "CREATE TABLE delDateExternal (cid INT4 UNSIGNED NOT NULL,objectId INT4 UNSIGNED NOT NULL,mailAddress VARCHAR(255) NOT NULL,displayName VARCHAR(255),confirm INT4 UNSIGNED NOT NULL,reason VARCHAR(255),PRIMARY KEY (cid,objectId, mailAddress),FOREIGN KEY (cid,objectId) REFERENCES del_dates(cid,intfield01)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

    @Override
    public String[] getDependencies() {
        return new String[]{"com.openexchange.groupware.update.tasks.AddAppointmentParticipantsIndexTask"};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        Connection con = Database.getNoTimeout(params.getContextId(), true);
        try {
            con.setAutoCommit(false);
            this.innerPerform(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(params.getContextId(), true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerPerform(Connection con) throws SQLException {
        SQLException toThrow;
        block15: {
            Statement stmt;
            block14: {
                toThrow = null;
                for (String tableName : this.TABLES) {
                    try {
                        Tools.checkAndAddColumns(con, tableName, this.COLUMNS);
                    }
                    catch (SQLException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                        if (null != toThrow) continue;
                        toThrow = e;
                    }
                }
                try {
                    if (Tools.tableExists(con, "dateExternal")) break block14;
                    stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute(DATES_EXTERNAL_CREATE);
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                catch (SQLException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    if (null != toThrow) break block14;
                    toThrow = e;
                }
            }
            try {
                if (Tools.tableExists(con, "delDateExternal")) break block15;
                stmt = null;
                try {
                    stmt = con.createStatement();
                    stmt.execute(DELDATES_EXTERNAL_CREATE);
                }
                finally {
                    DBUtils.closeSQLStuff(stmt);
                }
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                if (null != toThrow) break block15;
                toThrow = e;
            }
        }
        if (null != toThrow) {
            throw toThrow;
        }
    }
}

