/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class CorrectIndexes6_10
implements UpdateTask {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CorrectIndexes6_10.class));

    @Override
    public int addedWithVersion() {
        return 54;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            this.correctInfoStorePrimaryKey(con);
            this.correctInfoStoreLastModified(con);
            this.dropInfoStoreDocumentLastModified(con);
            this.createInfoStoreFolderIndex(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private void correctInfoStorePrimaryKey(Connection con) {
        for (String table : new String[]{"infostore", "del_infostore"}) {
            String[] columns = new String[]{"cid", "id"};
            String documentTable = table + "_document";
            String[] documentForeignKeyColumns = new String[]{"cid", "infostore_id"};
            try {
                if (!Tools.existsPrimaryKey(con, table, columns)) {
                    String foreignKey = Tools.existsForeignKey(con, table, columns, documentTable, documentForeignKeyColumns);
                    if (null != foreignKey) {
                        LOG.info((Object)("Removing foreign key on " + documentTable + " referencing " + table + " temporarily."));
                        Tools.dropForeignKey(con, documentTable, foreignKey);
                    }
                    LOG.info((Object)("Removing old primary key (cid,id,folder_id) from table " + table + "."));
                    Tools.dropPrimaryKey(con, table);
                    LOG.info((Object)("Creating new primary key (cid,id) on table " + table + "."));
                    Tools.createPrimaryKey(con, table, columns);
                    if (null == foreignKey || null != (foreignKey = Tools.existsForeignKey(con, table, columns, documentTable, documentForeignKeyColumns))) continue;
                    LOG.info((Object)("Recreating foreign key on " + documentTable + " referencing " + table + "."));
                    Tools.createForeignKey(con, documentTable, documentForeignKeyColumns, table, columns);
                    continue;
                }
                LOG.info((Object)("New primary key (ci,id) already exists on table " + table + "."));
            }
            catch (SQLException e) {
                LOG.error((Object)("Problem correcting primary key on table " + table + "."), (Throwable)e);
            }
        }
    }

    private void correctInfoStoreLastModified(Connection con) {
        String[] columns = new String[]{"cid", "last_modified"};
        for (String table : new String[]{"infostore", "del_infostore"}) {
            try {
                String indexName = Tools.existsIndex(con, table, new String[]{"last_modified"});
                if (null != indexName) {
                    LOG.info((Object)("Removing old index with columns (last_modified) on table " + table + "."));
                    Tools.dropIndex(con, table, indexName);
                } else {
                    LOG.info((Object)("Old index with columns (last_modified) on table " + table + " not found."));
                }
                indexName = Tools.existsIndex(con, table, columns);
                if (null == indexName) {
                    LOG.info((Object)("Creating new index named lastModified with columns (cid,last_modified) on table " + table + "."));
                    Tools.createIndex(con, table, "lastModified", columns, false);
                    continue;
                }
                LOG.info((Object)("New index named " + indexName + " with columns (cid,last_modified) already exists on table " + table + "."));
            }
            catch (SQLException e) {
                LOG.error((Object)("Problem correcting indexes on table " + table + "."), (Throwable)e);
            }
        }
    }

    private void dropInfoStoreDocumentLastModified(Connection con) {
        String[] columns = new String[]{"last_modified"};
        for (String table : new String[]{"infostore_document", "del_infostore_document"}) {
            try {
                String indexName = Tools.existsIndex(con, table, columns);
                if (null != indexName) {
                    LOG.info((Object)("Removing old index with columns (last_modified) on table " + table + "."));
                    Tools.dropIndex(con, table, indexName);
                    continue;
                }
                LOG.info((Object)("Old index with columns (last_modified) on table " + table + " not found."));
            }
            catch (SQLException e) {
                LOG.error((Object)("Problem correcting indexes on table " + table + "."), (Throwable)e);
            }
        }
    }

    private void createInfoStoreFolderIndex(Connection con) {
        String[] columns = new String[]{"cid", "folder_id"};
        for (String table : new String[]{"infostore", "del_infostore"}) {
            try {
                String indexName = Tools.existsIndex(con, table, columns);
                if (null == indexName) {
                    LOG.info((Object)("Creating new index named folder with columns (cid,folder_id) on table " + table + "."));
                    Tools.createIndex(con, table, "folder", columns, false);
                    continue;
                }
                LOG.info((Object)("New index named " + indexName + " with columns (cid,folder_id) already exists on table " + table + "."));
            }
            catch (SQLException e) {
                LOG.error((Object)("Problem correcting indexes on table " + table + "."), (Throwable)e);
            }
        }
    }
}

