/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks.mapping;

import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Task;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class TargetCosts
implements Mapper<BigDecimal> {
    public static final TargetCosts SINGLETON = new TargetCosts();

    protected TargetCosts() {
    }

    @Override
    public int getId() {
        return 307;
    }

    @Override
    public boolean isSet(Task task) {
        return task.containsTargetCosts();
    }

    @Override
    public String getDBColumnName() {
        return "target_costs";
    }

    @Override
    public String getDisplayName() {
        return "Estimated costs";
    }

    @Override
    public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
        if (null == task.getTargetCosts()) {
            stmt.setNull(pos, 2);
        } else {
            stmt.setBigDecimal(pos, task.getTargetCosts());
        }
    }

    @Override
    public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
        BigDecimal targetCosts = result.getBigDecimal(pos);
        if (!result.wasNull()) {
            task.setTargetCosts(targetCosts);
        }
    }

    @Override
    public boolean equals(Task task1, Task task2) {
        if (task1.getTargetCosts() == null) {
            return task2.getTargetCosts() == null;
        }
        if (task2.getTargetCosts() == null) {
            return task1.getTargetCosts() == null;
        }
        return task1.getTargetCosts().equals(task2.getTargetCosts());
    }

    @Override
    public BigDecimal get(Task task) {
        return task.getTargetCosts();
    }

    @Override
    public void set(Task task, BigDecimal value) {
        task.setTargetCosts(value);
    }
}

