/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;

public final class Tools {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Tools.class));

    private Tools() {
    }

    static Task createDummyTask(int identifier, int userId, String uid) {
        Task retval = new Task();
        retval.setObjectID(identifier);
        retval.setUid(uid);
        retval.setPrivateFlag(false);
        retval.setCreationDate(new Date());
        retval.setLastModified(new Date());
        retval.setCreatedBy(userId);
        retval.setModifiedBy(userId);
        retval.setRecurrenceType(0);
        retval.setNumberOfAttachments(0);
        return retval;
    }

    static boolean isFolderTask(FolderObject folder) {
        return 1 == folder.getModule();
    }

    static boolean isFolderPublic(FolderObject folder) {
        return 2 == folder.getType();
    }

    static boolean isFolderPrivate(FolderObject folder) {
        return 1 == folder.getType();
    }

    static boolean isFolderShared(FolderObject folder, User user) {
        return 1 == folder.getType() && folder.getCreatedBy() != user.getId();
    }

    static int getUserTaskStandardFolder(Context ctx, int userId) throws OXException {
        return new OXFolderAccess(ctx).getDefaultFolder(userId, 1).getObjectID();
    }

    static FolderObject getFolder(Context ctx, int folderId) throws OXException {
        return new OXFolderAccess(ctx).getFolderObject(folderId);
    }

    static FolderObject getFolder(Context ctx, Connection con, int folderId) throws OXException {
        return new OXFolderAccess(con, ctx).getFolderObject(folderId);
    }

    static void fillStandardFolders(Context ctx, Set<InternalParticipant> participants) throws OXException {
        for (InternalParticipant participant : participants) {
            if (-1 != participant.getFolderId()) continue;
            participant.setFolderId(Tools.getUserTaskStandardFolder(ctx, participant.getIdentifier()));
        }
    }

    static void fillStandardFolders(int cid, int taskId, Set<TaskParticipant> participants, Set<Folder> folders2, boolean privat) {
        HashMap<Integer, Folder> folderByUser = new HashMap<Integer, Folder>(folders2.size(), 1.0f);
        for (Folder folder : folders2) {
            folderByUser.put(Autoboxing.I((int)folder.getUser()), folder);
        }
        for (TaskParticipant participant : participants) {
            if (TaskParticipant.Type.INTERNAL != participant.getType()) continue;
            InternalParticipant internal = (InternalParticipant)participant;
            Folder folder = (Folder)folderByUser.get(Autoboxing.I((int)internal.getIdentifier()));
            if (null == folder) {
                if (privat) {
                    LOG.error((Object)TaskExceptionCode.PARTICIPANT_FOLDER_INCONSISTENCY.create(Autoboxing.I((int)internal.getIdentifier()), Autoboxing.I((int)taskId), Autoboxing.I((int)cid)));
                }
                folder = new Folder(0, internal.getIdentifier());
            }
            internal.setFolderId(folder.getIdentifier());
        }
    }

    static Context getContext(int contextId) throws OXException {
        return ContextStorage.getStorageContext(contextId);
    }

    static UserConfiguration getUserConfiguration(Context ctx, int userId) throws OXException {
        return UserConfigurationStorage.getInstance().getUserConfiguration(userId, ctx);
    }

    static UserPermissionBits getUserPermissionBits(Context ctx, int userId) throws OXException {
        return UserPermissionBitsStorage.getInstance().getUserPermissionBits(userId, ctx);
    }

    static User getUser(Context ctx, int userId) throws OXException {
        return UserStorage.getInstance().getUser(userId, ctx);
    }
}

