/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.SearchObject;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.sql.SearchStrings;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public class Search {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Search.class));
    private final Context ctx;
    private final User user;
    private final UserPermissionBits config;
    private final TaskSearchObject search;
    private final int orderBy;
    private final Order order;
    private final int[] columns;
    private final List<Integer> all = new ArrayList<Integer>();
    private final List<Integer> own = new ArrayList<Integer>();
    private final List<Integer> shared = new ArrayList<Integer>();

    public Search(Context ctx, User user, UserPermissionBits config, TaskSearchObject search, int orderBy, Order order, int[] columns) {
        this.config = config;
        this.ctx = ctx;
        this.user = user;
        this.search = search;
        this.orderBy = orderBy;
        this.order = order;
        this.columns = columns;
    }

    public SearchIterator<Task> perform() throws OXException, OXException {
        this.checkConditions();
        this.prepareFolder();
        if (this.all.size() + this.own.size() + this.shared.size() == 0) {
            return SearchIteratorAdapter.emptyIterator();
        }
        return TaskStorage.getInstance().search(this.ctx, this.getUserId(), this.search, this.orderBy, this.order, this.columns, this.all, this.own, this.shared);
    }

    private void checkConditions() throws OXException {
        if (SearchObject.NO_PATTERN == this.search.getPattern()) {
            return;
        }
        int minimumSearchCharacters = ServerConfig.getInt(ServerConfig.Property.MINIMUM_SEARCH_CHARACTERS);
        if (0 == minimumSearchCharacters) {
            return;
        }
        if (SearchStrings.lengthWithoutWildcards(this.search.getPattern()) < minimumSearchCharacters) {
            throw TaskExceptionCode.PATTERN_TOO_SHORT.create(Autoboxing.I((int)minimumSearchCharacters));
        }
    }

    private void prepareFolder() throws OXException, OXException {
        SearchIterator<FolderObject> folders2;
        if (this.search.hasFolders()) {
            folders2 = Search.loadFolder(this.ctx, this.search.getFolders());
        } else {
            folders2 = OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfModule(this.getUserId(), this.user.getGroups(), this.config.getAccessibleModules(), 1, this.ctx);
        }
        while (folders2.hasNext()) {
            FolderObject folder = (FolderObject)folders2.next();
            if (!Permission.isFolderVisible(this.ctx, this.user, this.config, folder) || Permission.canOnlySeeFolder(this.ctx, this.user, this.config, folder)) continue;
            Permission.checkReadInFolder(this.ctx, this.user, this.config, folder);
            if (folder.isShared(this.getUserId()) && !Permission.canReadInFolder(this.ctx, this.user, this.config, folder)) {
                this.shared.add(folder.getObjectID());
                continue;
            }
            if (Permission.canReadInFolder(this.ctx, this.user, this.config, folder)) {
                this.own.add(folder.getObjectID());
                continue;
            }
            this.all.add(folder.getObjectID());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Search tasks, all: " + this.all + ", own: " + this.own + ", shared: " + this.shared));
        }
    }

    private static SearchIterator<FolderObject> loadFolder(Context ctx, int[] folderIds) throws OXException {
        ArrayList<FolderObject> retval = new ArrayList<FolderObject>(folderIds.length);
        for (int folderId : folderIds) {
            retval.add(Tools.getFolder(ctx, folderId));
        }
        return new SearchIteratorAdapter(retval.iterator());
    }

    private int getUserId() {
        return this.user.getId();
    }
}

