/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.ReminderWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.json.ReminderAJAXRequest;
import com.openexchange.groupware.reminder.json.actions.AbstractReminderAction;
import com.openexchange.log.LogFactory;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="range", description="Get reminder range.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="end", description="The End date of the reminder range.")}, responseDescription="An Array with all reminders which are scheduled until the specified time. Each reminder is described in Reminder response.")
public final class RangeAction
extends AbstractReminderAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(RangeAction.class));

    public RangeAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected AJAXRequestResult perform(ReminderAJAXRequest req) throws OXException, JSONException {
        Date end = req.checkDate("end");
        TimeZone tz = req.getTimeZone();
        String timeZoneId = req.getParameter("timezone");
        TimeZone timeZone = null == timeZoneId ? tz : TimeZoneUtils.getTimeZone(timeZoneId);
        ReminderWriter reminderWriter = new ReminderWriter(timeZone);
        ServerSession session = req.getSession();
        ReminderHandler reminderSql = new ReminderHandler(session.getContext());
        SearchIterator<ReminderObject> it = reminderSql.getArisingReminder(session, session.getContext(), session.getUser(), end);
        JSONArray jsonResponseArray = new JSONArray();
        try {
            while (it.hasNext()) {
                ReminderObject reminder = (ReminderObject)it.next();
                if (reminder.isRecurrenceAppointment()) {
                    try {
                        if (!this.getLatestRecurringReminder(session, tz, end, reminder)) {
                            ReminderObject nextReminder = RangeAction.getNextRecurringReminder(session, tz, reminder);
                            if (nextReminder != null) {
                                reminderSql.updateReminder(nextReminder);
                                continue;
                            }
                            reminderSql.deleteReminder(reminder);
                            continue;
                        }
                    }
                    catch (OXException e) {
                        if (e.isGeneric(OXException.Generic.NOT_FOUND)) {
                            LOG.warn((Object)"Cannot load target object of this reminder.", (Throwable)e);
                            reminderSql.deleteReminder(reminder.getTargetId(), session.getUser().getId(), reminder.getModule());
                        }
                        LOG.error((Object)("Can not calculate recurrence of appointment " + reminder.getTargetId() + ':' + session.getContextId()), (Throwable)e);
                    }
                }
                if (!RangeAction.hasModulePermission(reminder, session) || !RangeAction.stillAccepted(reminder, session)) continue;
                JSONObject jsonReminderObj = new JSONObject(12);
                reminderWriter.writeObject(reminder, jsonReminderObj);
                jsonResponseArray.put((Object)jsonReminderObj);
            }
            return new AJAXRequestResult((Object)jsonResponseArray, "json");
        }
        finally {
            it.close();
        }
    }
}

