/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder;

import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.reminder.ReminderConfig;
import com.openexchange.java.Streams;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class ReminderConfigImpl
extends AbstractConfigWrapper
implements ReminderConfig {
    private boolean isReminderEnabled = false;
    private int reminderInterval = 3600000;
    private boolean isInit = false;
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ReminderConfigImpl.class));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReminderConfigImpl(String propfile) {
        if (this.isInit) {
            return;
        }
        if (propfile == null) {
            LOG.error((Object)"missing propfile");
            return;
        }
        Properties prop = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("try to load propfile: " + propfile));
            }
            prop = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propfile);
                prop.load(fis);
            }
            catch (Throwable throwable) {
                Streams.close(fis);
                throw throwable;
            }
            Streams.close((Closeable)fis);
        }
        catch (FileNotFoundException exc) {
            LOG.error((Object)("Cannot find propfile: " + propfile), (Throwable)exc);
        }
        catch (IOException exc) {
            LOG.error((Object)("Cannot read propfile: " + propfile), (Throwable)exc);
        }
        this.isReminderEnabled = ReminderConfigImpl.parseProperty(prop, "com.openexchange.groupware.reminder.isReminderEnabled", this.isReminderEnabled);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reminder property: com.openexchange.groupware.reminder.isReminderEnabled=" + this.isReminderEnabled));
        }
        this.reminderInterval = ReminderConfigImpl.parseProperty(prop, "com.openexchange.groupware.reminder.reminderInterval", this.reminderInterval);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reminder property: com.openexchange.groupware.reminder.reminderInterval=" + this.reminderInterval));
        }
        this.isInit = true;
    }

    @Override
    public boolean isReminderEnabled() {
        return this.isReminderEnabled;
    }

    @Override
    public int getReminderInterval() {
        return this.reminderInterval;
    }
}

