/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify;

import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.notify.EmailableParticipant;
import com.openexchange.groupware.notify.ParticipantNotify;
import com.openexchange.groupware.notify.PooledNotification;
import com.openexchange.groupware.notify.State;
import com.openexchange.i18n.tools.RenderMap;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;

public final class NotificationPool {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(NotificationPool.class));
    private static final NotificationPool instance = new NotificationPool();
    private final AtomicBoolean started = new AtomicBoolean();
    private final ReadWriteLock lock;
    private final Lock readLock;
    private ScheduledTimerTask timerTask;
    private final Map<PooledNotification, PooledNotification> map = new ConcurrentHashMap<PooledNotification, PooledNotification>(1024);
    private final DelayQueue<PooledNotification> queue = new DelayQueue();

    public static NotificationPool getInstance() {
        return instance;
    }

    private NotificationPool() {
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByObject(int objectId, int contextId) {
        this.readLock.lock();
        try {
            Iterator<PooledNotification> queueIter = this.queue.iterator();
            while (queueIter.hasNext()) {
                PooledNotification pn = queueIter.next();
                if (!pn.equalsByObject(objectId, contextId)) continue;
                this.map.remove(pn);
                queueIter.remove();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(PooledNotification pooledNotification) {
        this.readLock.lock();
        try {
            PooledNotification prev = this.map.get(pooledNotification);
            if (prev == null) {
                this.map.put(pooledNotification, pooledNotification);
                this.queue.offer(pooledNotification);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("New pooled notification added for receiver " + pooledNotification.getParticipant().email));
                }
            } else {
                prev.merge(pooledNotification);
                prev.touch();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Pooled notification merged for receiver " + pooledNotification.getParticipant().email));
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<PooledNotification> getNotifications() {
        return new ArrayList<PooledNotification>(this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.readLock.lock();
        try {
            this.queue.clear();
            this.map.clear();
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void sendAllMessages() {
        new NotificationPoolTimerTask(this.map, this.queue, this.lock.writeLock()).run();
    }

    public void startup() {
        TimerService timer;
        if (this.started.compareAndSet(false, true) && null != (timer = ServerServiceRegistry.getInstance().getService(TimerService.class))) {
            this.timerTask = timer.scheduleWithFixedDelay((Runnable)new NotificationPoolTimerTask(this.map, this.queue, this.lock.writeLock()), 1000L, 60000L);
        }
    }

    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.timerTask.cancel(false);
            TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (null != timer) {
                timer.purge();
            }
            this.map.clear();
            this.queue.clear();
            this.timerTask = null;
        }
    }

    private class NotificationPoolTimerTask
    implements Runnable {
        private final Log logger = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(NotificationPoolTimerTask.class));
        private final Lock taskWriteLock;
        private final Map<PooledNotification, PooledNotification> taskMap;
        private final DelayQueue<PooledNotification> taskQueue;

        public NotificationPoolTimerTask(Map<PooledNotification, PooledNotification> map, DelayQueue<PooledNotification> queue, Lock writeLock) {
            this.taskMap = map;
            this.taskQueue = queue;
            this.taskWriteLock = writeLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.taskWriteLock.lock();
            try {
                PooledNotification cur = (PooledNotification)this.taskQueue.poll();
                if (null != cur) {
                    StringBuilder b = new StringBuilder(2048);
                    do {
                        this.taskMap.remove(cur);
                        this.handlePooledNotification(cur, b);
                    } while (null != (cur = (PooledNotification)this.taskQueue.poll()));
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)t.getMessage(), t);
            }
            finally {
                this.taskWriteLock.unlock();
            }
        }

        private void handlePooledNotification(PooledNotification cur, StringBuilder b) {
            EmailableParticipant p = cur.getParticipant();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)b.append("Found elapsed pooled notification for receiver ").append(p.email).toString());
                b.setLength(0);
            }
            RenderMap renderMap = cur.getRenderMap();
            renderMap.applyLocale(cur.getLocale());
            renderMap.applyTimeZone(p.timeZone == null ? TimeZone.getDefault() : p.timeZone);
            State state = cur.getState();
            CalendarObject calendarObject = cur.getCalendarObject();
            if (ParticipantNotify.checkStartAndEndDate(calendarObject, state.getModule())) {
                ParticipantNotify.MailMessage mmsg = 1 == p.type ? ParticipantNotify.createUserMessage(cur.getSession(), calendarObject, p, ParticipantNotify.userCanReadObject(p, calendarObject, cur.getSession()), cur.getTitle(), cur.getState().getAction(), state, cur.getLocale(), cur.getRenderMap(), true, b) : ParticipantNotify.createParticipantMessage(cur.getSession(), calendarObject, p, cur.getTitle(), cur.getState().getAction(), state, cur.getLocale(), cur.getRenderMap(), true, b);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)b.append("Pooled ").append(1 == state.getModule() ? "Appointment" : "Task").append(" (id = ").append(calendarObject.getObjectID()).append(") notification message generated for receiver ").append(p.email).toString());
                    b.setLength(0);
                }
                if (null != mmsg) {
                    ParticipantNotify.sendMessage(mmsg, cur.getSession(), calendarObject, state);
                }
            }
        }
    }
}

