/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.notify.EmailableParticipant;
import com.openexchange.groupware.notify.NotificationConfig;
import com.openexchange.groupware.notify.State;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.i18n.tools.RenderMap;
import com.openexchange.i18n.tools.StringTemplate;
import com.openexchange.i18n.tools.Template;
import com.openexchange.i18n.tools.TemplateToken;
import com.openexchange.i18n.tools.replacement.ModuleReplacement;
import com.openexchange.i18n.tools.replacement.StringReplacement;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public abstract class LinkableState
implements State {
    private static final Log LOG;
    protected static volatile Template object_link_template;
    private static final String hostname;
    private static final UnknownHostException warnSpam;

    @Override
    public void addSpecial(CalendarObject obj, CalendarObject oldObj, RenderMap renderMap, EmailableParticipant p) {
        renderMap.put(new StringReplacement(TemplateToken.LINK, this.generateLink(obj, p)).setChanged(true));
    }

    public String generateLink(CalendarObject obj, EmailableParticipant p) {
        String hostnameStr;
        if (object_link_template == null) {
            this.loadTemplate();
        }
        RenderMap subst = new RenderMap();
        switch (this.getModule()) {
            case 1: {
                subst.put(new ModuleReplacement(0));
                break;
            }
            case 4: {
                subst.put(new ModuleReplacement(1));
                break;
            }
            default: {
                subst.put(new ModuleReplacement(-1));
            }
        }
        int folder = p.folderId;
        if (folder == -1) {
            folder = obj.getParentFolderID();
        }
        subst.put(new StringReplacement(TemplateToken.FOLDER_ID, Integer.toString(folder)));
        subst.put(new StringReplacement(TemplateToken.OBJECT_ID, Integer.toString(obj.getObjectID())));
        subst.put(new StringReplacement(TemplateToken.UI_WEB_PATH, ServerConfig.getProperty(ServerConfig.Property.UI_WEB_PATH)));
        HostnameService hostnameService = ServerServiceRegistry.getInstance().getService(HostnameService.class);
        if (hostnameService == null || (hostnameStr = hostnameService.getHostname(p.id, p.cid)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No host name service available or returned host name from service is null; using local host name as fallback.");
            }
            if (warnSpam != null) {
                LOG.error((Object)"Can't resolve my own hostname, using 'localhost' instead, which is certainly not what you want!", (Throwable)warnSpam);
            }
            subst.put(new StringReplacement(TemplateToken.HOSTNAME, hostname));
        } else {
            subst.put(new StringReplacement(TemplateToken.HOSTNAME, hostnameStr));
        }
        return object_link_template.render(p.getLocale(), subst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTemplate() {
        Class<LinkableState> clazz = LinkableState.class;
        synchronized (LinkableState.class) {
            Pattern patternSlashFixer = Pattern.compile("^//+|[^:]//+");
            String property = patternSlashFixer.matcher(NotificationConfig.getProperty(NotificationConfig.NotificationProperty.OBJECT_LINK, "")).replaceAll("/");
            object_link_template = new StringTemplate(property);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        String hn;
        LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(LinkableState.class));
        UnknownHostException uhe = null;
        try {
            hn = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            hn = "localhost";
            uhe = e;
        }
        hostname = hn;
        warnSpam = uhe;
    }
}

