/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.configuration.DirectoryService;
import com.openexchange.groupware.ldap.Credentials;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.file.TagFiller;
import com.openexchange.tools.file.TagFillerAdapter;
import com.openexchange.tools.tag.LineParserUtility;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;

public final class LdapUtility {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(LdapUtility.class));
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private static final TagFiller FILLER = new TagFillerAdapter(){

        @Override
        public String replace(String tag, Object data) {
            TagFillerData temp = (TagFillerData)data;
            String retval = tag;
            if (temp.datamap != null && temp.datamap.containsKey(tag)) {
                retval = (String)temp.datamap.get(tag);
            } else if (temp.values != null && tag.endsWith("BaseDN")) {
                try {
                    retval = LdapUtility.getSearchBaseDN(tag, temp.values);
                }
                catch (OXException e) {
                    retval = e.getMessage();
                }
            } else {
                try {
                    String property = LdapUtility.findProperty(tag, false);
                    if (null != property && !property.equals('[' + tag + ']')) {
                        retval = LineParserUtility.parseLine(property, this, data);
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    retval = tag;
                }
            }
            return retval;
        }
    };
    private static Object mutex = new Object();
    private static volatile Properties customization;

    private LdapUtility() {
    }

    public static void setLogin(LdapContext context, String login, String pass) throws NamingException {
        if (null == context) {
            return;
        }
        context.addToEnvironment("java.naming.security.principal", login);
        context.addToEnvironment("java.naming.security.credentials", pass);
        context.reconnect(null);
    }

    public static void removeLogin(LdapContext context) throws NamingException {
        if (null == context) {
            return;
        }
        context.removeFromEnvironment("java.naming.security.principal");
        context.removeFromEnvironment("java.naming.security.credentials");
    }

    static String getSearchBaseDN(String propname, Credentials cred) throws OXException {
        String retval = LdapUtility.findProperty(propname, true);
        if (retval.length() > 0 && retval.charAt(0) == '[' && retval.charAt(retval.length() - 1) == ']') {
            retval = retval.indexOf(91, 1) == -1 ? cred.getValue(retval.substring(1, retval.length() - 1)) : LineParserUtility.parseLine(retval, FILLER, new TagFillerData(cred, EMPTY_MAP));
        }
        return retval;
    }

    public static Name append(Name name1, Name name2) throws InvalidNameException {
        Name retval = (Name)name2.clone();
        retval.addAll(name1);
        return retval;
    }

    public static String prepareSearchPattern(String pattern) {
        StringBuilder modifiedPattern = new StringBuilder(pattern.replace('*', '%'));
        if (modifiedPattern.length() == 0) {
            modifiedPattern.append('%');
        }
        if (modifiedPattern.charAt(0) != '%') {
            modifiedPattern.insert(0, '%');
        }
        if (modifiedPattern.charAt(modifiedPattern.length() - 1) != '%') {
            modifiedPattern.append('%');
        }
        return modifiedPattern.toString();
    }

    static String findProperty(String propname, boolean mustExist) throws OXException {
        String retval = LdapUtility.getCustomization().getProperty(propname);
        if (retval == null && mustExist) {
            throw LdapExceptionCode.PROPERTY_MISSING.create(propname).setPrefix(EnumComponent.LDAP.getAbbreviation());
        }
        return retval;
    }

    static String findProperty(String propname) throws OXException {
        return LdapUtility.findProperty(propname, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getCustomization() {
        Object object = mutex;
        synchronized (object) {
            if (null == customization) {
                customization = DirectoryService.getCustomization();
            }
        }
        return customization;
    }

    public static <U> Class<? extends U> getImplementation(String className, Class<U> clazz) throws OXException {
        try {
            return Class.forName(className).asSubclass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw LdapExceptionCode.CLASS_NOT_FOUND.create(e, className).setPrefix(EnumComponent.LDAP.getAbbreviation());
        }
    }

    public static <T> T getInstance(Class<? extends T> clazz) throws OXException {
        try {
            Constructor<T> cons = clazz.getConstructor(new Class[0]);
            return cons.newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw LdapExceptionCode.INSTANTIATION_PROBLEM.create(e, clazz.getName()).setPrefix(EnumComponent.LDAP.getAbbreviation());
        }
        catch (NoSuchMethodException e) {
            throw LdapExceptionCode.INSTANTIATION_PROBLEM.create(e, clazz.getName()).setPrefix(EnumComponent.LDAP.getAbbreviation());
        }
        catch (InstantiationException e) {
            throw LdapExceptionCode.INSTANTIATION_PROBLEM.create(e, clazz.getName()).setPrefix(EnumComponent.LDAP.getAbbreviation());
        }
        catch (IllegalAccessException e) {
            throw LdapExceptionCode.INSTANTIATION_PROBLEM.create(e, clazz.getName()).setPrefix(EnumComponent.LDAP.getAbbreviation());
        }
        catch (IllegalArgumentException e) {
            throw LdapExceptionCode.INSTANTIATION_PROBLEM.create(e, clazz.getName()).setPrefix(EnumComponent.LDAP.getAbbreviation());
        }
        catch (InvocationTargetException e) {
            throw LdapExceptionCode.INSTANTIATION_PROBLEM.create(e, clazz.getName()).setPrefix(EnumComponent.LDAP.getAbbreviation());
        }
    }

    private static class TagFillerData {
        private final Credentials values;
        private final Map<String, String> datamap;

        public TagFillerData(Credentials values, Map<String, String> datamap) {
            this.values = values;
            this.datamap = datamap;
        }
    }
}

