/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockHelper;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;

public class EntityLockHelper
extends LockHelper {
    private final EntityLockManager entityLockManager;
    protected SessionHolder sessionHolder;
    private static final String TOKEN_PREFIX = "http://www.open-xchange.com/webdav/locks/";
    private static final int TOKEN_PREFIX_LENGTH = "http://www.open-xchange.com/webdav/locks/".length();

    public EntityLockHelper(EntityLockManager entityLockManager, SessionHolder sessionHolder, WebdavPath url) {
        super(entityLockManager, sessionHolder, url);
        this.sessionHolder = sessionHolder;
        this.entityLockManager = entityLockManager;
    }

    @Override
    protected WebdavLock toWebdavLock(Lock lock) {
        WebdavLock l = new WebdavLock();
        l.setDepth(0);
        l.setTimeout(lock.getTimeout());
        l.setToken(TOKEN_PREFIX + lock.getId());
        l.setType(WebdavLock.Type.WRITE_LITERAL);
        l.setScope(lock.getScope().equals((Object)LockManager.Scope.EXCLUSIVE) ? WebdavLock.Scope.EXCLUSIVE_LITERAL : WebdavLock.Scope.SHARED_LITERAL);
        l.setOwner(lock.getOwnerDescription());
        return l;
    }

    @Override
    protected Lock toLock(WebdavLock lock) {
        Lock l = new Lock();
        l.setId(Integer.parseInt(lock.getToken().substring(41)));
        l.setOwnerDescription(lock.getOwner());
        l.setScope(lock.getScope().equals((Object)WebdavLock.Scope.EXCLUSIVE_LITERAL) ? LockManager.Scope.EXCLUSIVE : LockManager.Scope.SHARED);
        l.setType(LockManager.Type.WRITE);
        l.setTimeout(lock.getTimeout());
        return l;
    }

    @Override
    protected int saveLock(WebdavLock lock) throws OXException {
        ServerSession session = this.getSession();
        return this.entityLockManager.lock(this.id, lock.getTimeout() == -1L ? -1L : lock.getTimeout(), lock.getScope().equals((Object)WebdavLock.Scope.EXCLUSIVE_LITERAL) ? LockManager.Scope.EXCLUSIVE : LockManager.Scope.SHARED, LockManager.Type.WRITE, lock.getOwner(), session.getContext(), UserStorage.getStorageUser(session.getUserId(), session.getContext()));
    }

    @Override
    protected void relock(WebdavLock lock) throws OXException {
        ServerSession session = this.getSession();
        int lockId = this.getLockId(lock);
        this.entityLockManager.relock(lockId, lock.getTimeout() == -1L ? -1L : lock.getTimeout(), lock.getScope().equals((Object)WebdavLock.Scope.EXCLUSIVE_LITERAL) ? LockManager.Scope.EXCLUSIVE : LockManager.Scope.SHARED, LockManager.Type.WRITE, lock.getOwner(), session.getContext(), UserStorage.getStorageUser(session.getUserId(), session.getContext()));
    }

    private int getLockId(WebdavLock lock) {
        return Integer.parseInt(lock.getToken().substring(TOKEN_PREFIX_LENGTH));
    }

    private ServerSession getSession() throws OXException {
        return ServerSessionAdapter.valueOf(this.sessionHolder.getSessionObject());
    }
}

