/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.AbstractDocumentListAction;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ReplaceDocumentIntoDelTableAction
extends AbstractDocumentListAction {
    private static final int batchSize = 100;

    @Override
    protected Object[] getAdditionals(DocumentMetadata doc) {
        return new Object[0];
    }

    protected void undoAction() throws OXException {
        List<DocumentMetadata> documents = this.getDocuments();
        if (null == documents || 0 == documents.size()) {
            return;
        }
        List<DocumentMetadata>[] slices = this.getSlices(100, documents);
        ArrayList<AbstractDBAction.UpdateBlock> updates = new ArrayList<AbstractDBAction.UpdateBlock>(slices.length << 1);
        for (int i = 0; i < slices.length; ++i) {
            List<String> deleteStmts = this.getQueryCatalog().getDelete(InfostoreQueryCatalog.Table.DEL_INFOSTORE, slices[i]);
            for (String deleteStmt : deleteStmts) {
                updates.add(new AbstractDBAction.Update(deleteStmt){

                    @Override
                    public void fillStatement() throws SQLException {
                        this.stmt.setInt(1, ReplaceDocumentIntoDelTableAction.this.getContext().getContextId());
                    }
                });
            }
        }
        this.doUpdates(updates);
    }

    public void perform() throws OXException {
        List<DocumentMetadata> documents = this.getDocuments();
        if (null == documents || 0 == documents.size()) {
            return;
        }
        final Integer contextID = this.getContext().getContextId();
        List<DocumentMetadata>[] slices = this.getSlices(100, documents);
        ArrayList<AbstractDBAction.UpdateBlock> updates = new ArrayList<AbstractDBAction.UpdateBlock>(slices.length);
        for (int i = 0; i < slices.length; ++i) {
            final List<DocumentMetadata> slice = slices[i];
            updates.add(new AbstractDBAction.Update(this.getQueryCatalog().getReplace(InfostoreQueryCatalog.Table.DEL_INFOSTORE, slice.size())){

                @Override
                public void fillStatement() throws SQLException {
                    int parameterIndex = 1;
                    for (DocumentMetadata document : slice) {
                        parameterIndex = ReplaceDocumentIntoDelTableAction.this.fillStmt(parameterIndex, this.stmt, ReplaceDocumentIntoDelTableAction.this.getQueryCatalog().getWritableDocumentFields(), document, contextID);
                    }
                }
            });
        }
        this.doUpdates(updates);
    }
}

