/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.datasource;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.contact.ContactService;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.image.ImageUtility;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;

public final class UserImageDataSource
implements ImageDataSource {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(UserImageDataSource.class));
    private static final String REGISTRATION_NAME = "com.openexchange.user.image";
    private static final String ALIAS = "/user/picture";
    private static final String ID_ARGUMENT = "com.openexchange.groupware.user.id";
    private static final UserImageDataSource INSTANCE = new UserImageDataSource();

    public static UserImageDataSource getInstance() {
        return INSTANCE;
    }

    private UserImageDataSource() {
    }

    public <D> Data<D> getData(Class<? extends D> type, DataArguments dataArguments, Session session) throws OXException {
        int userID;
        if (!InputStream.class.equals(type)) {
            throw DataExceptionCodes.TYPE_NOT_SUPPORTED.create(new Object[]{type.getName()});
        }
        String argument = dataArguments.get(ID_ARGUMENT);
        if (null == argument) {
            throw DataExceptionCodes.MISSING_ARGUMENT.create(new Object[]{ID_ARGUMENT});
        }
        try {
            userID = Integer.parseInt(argument);
        }
        catch (NumberFormatException e) {
            throw DataExceptionCodes.INVALID_ARGUMENT.create((Throwable)e, new Object[]{ID_ARGUMENT, argument});
        }
        Contact user = UserImageDataSource.optUser(session, userID, ContactField.IMAGE1, ContactField.IMAGE1_CONTENT_TYPE);
        if (null == user) {
            throw UserExceptionCode.USER_NOT_FOUND.create(userID, session.getContextId());
        }
        byte[] imageBytes = user.getImage1();
        DataProperties properties = new DataProperties(5);
        properties.put("com.openexchange.conversion.folderId", String.valueOf(6));
        properties.put("com.openexchange.conversion.id", String.valueOf(userID));
        if (null == imageBytes) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)new StringAllocator("Requested a non-existing image in user contact: user-id=").append(userID).append(" context=").append(session.getContextId()).append(" session-user=").append(session.getUserId()).append("\nReturning an empty image as fallback.").toString());
            }
            properties.put("com.openexchange.conversion.content-type", "image/jpg");
            properties.put("com.openexchange.conversion.size", String.valueOf(0));
            return new SimpleData((Object)new UnsynchronizedByteArrayInputStream(new byte[0]), properties);
        }
        properties.put("com.openexchange.conversion.content-type", user.getImageContentType());
        properties.put("com.openexchange.conversion.size", String.valueOf(imageBytes.length));
        properties.put("com.openexchange.conversion.name", user.getImageContentType().replace('/', '.'));
        return new SimpleData((Object)new UnsynchronizedByteArrayInputStream(imageBytes), properties);
    }

    public String[] getRequiredArguments() {
        return new String[]{ID_ARGUMENT};
    }

    public Class<?>[] getTypes() {
        return new Class[]{InputStream.class};
    }

    @Override
    public String getRegistrationName() {
        return REGISTRATION_NAME;
    }

    @Override
    public String getAlias() {
        return ALIAS;
    }

    @Override
    public ImageLocation parseUrl(String url) {
        return ImageUtility.parseImageLocationFrom(url);
    }

    @Override
    public DataArguments generateDataArgumentsFrom(ImageLocation imageLocation) {
        DataArguments dataArguments = new DataArguments(1);
        dataArguments.put(ID_ARGUMENT, imageLocation.getId());
        return dataArguments;
    }

    @Override
    public String generateUrl(ImageLocation imageLocation, Session session) throws OXException {
        Contact user;
        StringBuilder stringBuilder = new StringBuilder();
        ImageUtility.startImageUrl(imageLocation, session, this, true, stringBuilder);
        if (null == imageLocation.getTimestamp() && null != (user = UserImageDataSource.optUser(session, imageLocation, ContactField.LAST_MODIFIED)) && null != user.getLastModified()) {
            stringBuilder.append('&').append("timestamp=").append(user.getLastModified().getTime());
        }
        return stringBuilder.toString();
    }

    @Override
    public long getExpires() {
        return -1L;
    }

    @Override
    public String getETag(ImageLocation imageLocation, Session session) throws OXException {
        Contact user;
        String timestamp = imageLocation.getTimestamp();
        if (null == timestamp && null != (user = UserImageDataSource.optUser(session, imageLocation, ContactField.LAST_MODIFIED)) && null != user.getLastModified()) {
            timestamp = String.valueOf(user.getLastModified().getTime());
        }
        return null != timestamp ? timestamp : "0";
    }

    @Override
    public ImageLocation parseRequest(AJAXRequestData requestData) {
        return ImageUtility.parseImageLocationFrom(requestData);
    }

    private static Contact optUser(Session session, ImageLocation imageLocation, ContactField ... fields) throws OXException {
        return UserImageDataSource.optUser(session, ImageUtility.getUnsignedInteger(imageLocation.getId()), fields);
    }

    private static Contact optUser(Session session, int userID, ContactField ... fields) {
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
        if (null != contactService) {
            try {
                return contactService.getUser(session, userID, fields);
            }
            catch (OXException e) {
                LOG.debug((Object)"error getting user contact", (Throwable)e);
            }
        }
        return null;
    }
}

