/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.virtual.sql;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.virtual.VirtualFolder;
import com.openexchange.folderstorage.virtual.VirtualPermission;
import com.openexchange.folderstorage.virtual.VirtualServiceRegistry;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;

public final class Select {
    private static final String SQL_SELECT = "SELECT parentId, name, modifiedBy, lastModified FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT_BCK = "SELECT parentId, name, modifiedBy, lastModified FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT2 = "SELECT folderId FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT2_BCK = "SELECT folderId, name FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT_SUBF = "SELECT folderId, name FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?";
    private static final String SQL_SELECT_SUBF_BCK = "SELECT folderId, name FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?";
    private static final String SQL_SELECT_PERMS = "SELECT entity, groupFlag, fp, orp, owp, odp, adminFlag, system FROM virtualPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT_PERMS_BCK = "SELECT entity, groupFlag, fp, orp, owp, odp, adminFlag, system FROM virtualBackupPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT_SUBSCRIPTION = "SELECT subscribed FROM virtualSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT_SUBSCRIPTION_BCK = "SELECT subscribed FROM virtualBackupSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT2_SUBF = "SELECT folderId, name FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?";
    private static final String SQL_SELECT2_SUBF_BCK = "SELECT folderId, name FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?";

    private Select() {
    }

    public static boolean containsFolder(int cid, int tree, int user, String folderId, StorageType storageType) throws OXException {
        DatabaseService databaseService = (DatabaseService)VirtualServiceRegistry.getServiceRegistry().getService(DatabaseService.class, true);
        Connection con = databaseService.getReadOnly(cid);
        try {
            boolean bl;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = con.prepareStatement(StorageType.WORKING.equals(storageType) ? SQL_SELECT2 : SQL_SELECT2_BCK);
                int pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                stmt.setInt(pos++, user);
                stmt.setString(pos, folderId);
                rs = stmt.executeQuery();
                bl = rs.next();
            }
            catch (SQLException e) {
                try {
                    throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(rs, stmt);
            return bl;
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillFolder(int cid, int tree, int user, Locale locale, VirtualFolder virtualFolder, StorageType storageType) throws OXException {
        DatabaseService databaseService = (DatabaseService)VirtualServiceRegistry.getServiceRegistry().getService(DatabaseService.class, true);
        Connection con = databaseService.getReadOnly(cid);
        String folderId = virtualFolder.getID();
        try {
            int pos;
            boolean working;
            ResultSet rs;
            PreparedStatement stmt;
            block28: {
                stmt = null;
                rs = null;
                working = StorageType.WORKING.equals(storageType);
                try {
                    stmt = con.prepareStatement(working ? SQL_SELECT : SQL_SELECT_BCK);
                    int pos2 = 1;
                    stmt.setInt(pos2++, cid);
                    stmt.setInt(pos2++, tree);
                    stmt.setInt(pos2++, user);
                    stmt.setString(pos2, folderId);
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        throw FolderExceptionErrorMessage.NOT_FOUND.create(folderId, tree);
                    }
                    pos2 = 1;
                    virtualFolder.setParentID(rs.getString(pos2++));
                    virtualFolder.setName(rs.getString(pos2++));
                    int modifiedBy = rs.getInt(pos2++);
                    if (rs.wasNull()) {
                        virtualFolder.setModifiedBy(-1);
                    } else {
                        virtualFolder.setModifiedBy(modifiedBy);
                    }
                    long date = rs.getLong(pos2);
                    if (rs.wasNull()) {
                        virtualFolder.setLastModified(null);
                        break block28;
                    }
                    virtualFolder.setLastModified(new Date(date));
                }
                catch (SQLException e) {
                    try {
                        Log LOG;
                        if (null != stmt && (LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Select.class))).isDebugEnabled()) {
                            String sql = Select.getSQLString(stmt);
                            LOG.debug((Object)new StringAllocator(sql.length() + 16).append("Failed SQL:\n\t").append(sql).toString());
                        }
                        throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(rs, stmt);
                        throw throwable;
                    }
                }
            }
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = null;
            String[] subfolderIds = Select.getSubfolderIds(cid, tree, user, locale, folderId, storageType, con);
            virtualFolder.setSubfolderIDs(subfolderIds);
            virtualFolder.setSubscribedSubfolders(subfolderIds != null && subfolderIds.length > 0);
            try {
                stmt = con.prepareStatement(working ? SQL_SELECT_PERMS : SQL_SELECT_PERMS_BCK);
                pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                stmt.setInt(pos++, user);
                stmt.setString(pos, folderId);
                rs = stmt.executeQuery();
                ArrayList<VirtualPermission> permissions = new ArrayList<VirtualPermission>();
                while (rs.next()) {
                    VirtualPermission p = new VirtualPermission();
                    pos = 1;
                    p.setEntity(rs.getInt(pos++));
                    p.setGroup(rs.getInt(pos++) > 0);
                    p.setFolderPermission(rs.getInt(pos++));
                    p.setReadPermission(rs.getInt(pos++));
                    p.setWritePermission(rs.getInt(pos++));
                    p.setDeletePermission(rs.getInt(pos++));
                    p.setAdmin(rs.getInt(pos++) > 0);
                    p.setSystem(rs.getInt(pos++));
                    permissions.add(p);
                }
                if (permissions.isEmpty()) {
                    virtualFolder.setPermissions(null);
                } else {
                    virtualFolder.setPermissions(permissions.toArray(new Permission[permissions.size()]));
                }
            }
            catch (SQLException e) {
                Log LOG;
                if (null != stmt && (LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Select.class))).isDebugEnabled()) {
                    String sql = Select.getSQLString(stmt);
                    LOG.debug((Object)new StringAllocator(sql.length() + 16).append("Failed SQL:\n\t").append(sql).toString());
                }
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.closeSQLStuff(rs, stmt);
            }
            stmt = null;
            try {
                stmt = con.prepareStatement(working ? SQL_SELECT_SUBSCRIPTION : SQL_SELECT_SUBSCRIPTION_BCK);
                pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                stmt.setInt(pos++, user);
                stmt.setString(pos, folderId);
                rs = stmt.executeQuery();
                pos = 1;
                boolean subscribed = true;
                if (rs.next()) {
                    subscribed = rs.getInt(pos) > 0;
                }
                virtualFolder.setSubscribed(subscribed);
            }
            catch (SQLException e) {
                Log LOG;
                if (null != stmt && (LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Select.class))).isDebugEnabled()) {
                    String sql = Select.getSQLString(stmt);
                    LOG.debug((Object)new StringAllocator(sql.length() + 16).append("Failed SQL:\n\t").append(sql).toString());
                }
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.closeSQLStuff(rs, stmt);
            }
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSubfolderIds(int cid, int tree, int user, Locale locale, String parentId, StorageType storageType) throws OXException {
        DatabaseService databaseService = (DatabaseService)VirtualServiceRegistry.getServiceRegistry().getService(DatabaseService.class, true);
        Connection con = databaseService.getReadOnly(cid);
        try {
            String[] stringArray = Select.getSubfolderIds(cid, tree, user, locale, parentId, storageType, con);
            return stringArray;
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    public static String[] getSubfolderIds(int cid, int tree, int user, Locale locale, String parentId, StorageType storageType, Connection con) throws OXException {
        String[] stringArray;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> subfolderIds;
            boolean working = StorageType.WORKING.equals(storageType);
            stmt = con.prepareStatement(working ? "SELECT folderId, name FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?" : "SELECT folderId, name FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?");
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, parentId);
            rs = stmt.executeQuery();
            pos = 1;
            if (FolderStorage.ROOT_ID.equals(parentId)) {
                ArrayList<String[]> fns = new ArrayList<String[]>();
                while (rs.next()) {
                    String[] sa = new String[]{rs.getString(pos), rs.getString(2)};
                    fns.add(sa);
                }
                Collections.sort(fns, new PrivateSubfolderIDComparator(locale));
                subfolderIds = new ArrayList<String>(fns.size());
                for (String[] fn : fns) {
                    subfolderIds.add(fn[0]);
                }
            } else {
                TreeMap<String, String> treeMap = new TreeMap<String, String>(new FolderNameComparator(locale));
                StringHelper stringHelper = StringHelper.valueOf(locale);
                while (rs.next()) {
                    treeMap.put(stringHelper.getString(rs.getString(2)), rs.getString(pos));
                }
                Set entrySet = treeMap.entrySet();
                subfolderIds = new ArrayList(entrySet.size());
                for (Map.Entry entry : entrySet) {
                    subfolderIds.add((String)entry.getValue());
                }
            }
            stringArray = subfolderIds.toArray(new String[subfolderIds.size()]);
        }
        catch (SQLException e) {
            try {
                Log LOG;
                if (null != stmt && (LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Select.class))).isDebugEnabled()) {
                    String sql = Select.getSQLString(stmt);
                    LOG.debug((Object)new StringBuilder(sql.length() + 16).append("Failed SQL:\n\t").append(sql).toString());
                }
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return stringArray;
    }

    private static String getSQLString(PreparedStatement stmt) {
        String toString = stmt.toString();
        return toString.substring(toString.indexOf(": ") + 2);
    }

    private static final class PrivateSubfolderIDComparator
    implements Comparator<String[]> {
        private final Collator collator;

        public PrivateSubfolderIDComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            String privateId = "1";
            Integer privateComp = this.conditionalCompare("1".equals(o1[0]), "1".equals(o2[0]));
            if (null != privateComp) {
                return privateComp;
            }
            String publicId = "2";
            Integer publicComp = this.conditionalCompare("2".equals(o1[0]), "2".equals(o2[0]));
            if (null != publicComp) {
                return publicComp;
            }
            String sharedId = "3";
            Integer sharedComp = this.conditionalCompare("3".equals(o1[0]), "3".equals(o2[0]));
            if (null != sharedComp) {
                return sharedComp;
            }
            String uiName = "Unified Inbox";
            Integer unifiedInboxComp = this.conditionalCompare("Unified Inbox".equalsIgnoreCase(o1[1]), "Unified Inbox".equalsIgnoreCase(o2[1]));
            if (null != unifiedInboxComp) {
                return unifiedInboxComp;
            }
            return this.collator.compare(o1[1], o2[1]);
        }

        private Integer conditionalCompare(boolean b1, boolean b2) {
            if (b1) {
                if (!b2) {
                    return -1;
                }
                return 0;
            }
            if (b2) {
                return 1;
            }
            return null;
        }
    }

    private static final class FolderNameComparator
    implements Comparator<String> {
        private final Collator collator;

        public FolderNameComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(String o1, String o2) {
            return this.collator.compare(o1, o2);
        }
    }
}

