/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.sql;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.outlook.sql.Utility;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class Delete {
    private static final String SQL_DELETE_SUBS = "DELETE FROM virtualSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_GLOBAL_DELETE_SUBS = "DELETE FROM virtualSubscription WHERE cid = ? AND tree = ? AND folderId = ?";
    private static final String SQL_DELETE_INSERT_SUBS = "INSERT INTO virtualBackupSubscription SELECT * FROM virtualSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_GLOBAL_DELETE_INSERT_SUBS = "INSERT INTO virtualBackupSubscription SELECT * FROM virtualSubscription WHERE cid = ? AND tree = ? AND folderId = ?";
    private static final String SQL_DELETE_PERMS = "DELETE FROM virtualPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_GLOBAL_DELETE_PERMS = "DELETE FROM virtualPermission WHERE cid = ? AND tree = ? AND folderId = ?";
    private static final String SQL_DELETE_INSERT_PERMS = "INSERT INTO virtualBackupPermission SELECT * FROM virtualPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_GLOBAL_DELETE_INSERT_PERMS = "INSERT INTO virtualBackupPermission SELECT * FROM virtualPermission WHERE cid = ? AND tree = ? AND folderId = ?";
    private static final String SQL_DELETE = "DELETE FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_GLOBAL_DELETE = "DELETE FROM virtualTree WHERE cid = ? AND tree = ? AND folderId = ?";
    private static final String SQL_DELETE_INSERT = "INSERT INTO virtualBackupTree SELECT * FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_GLOBAL_DELETE_INSERT = "INSERT INTO virtualBackupTree SELECT * FROM virtualTree WHERE cid = ? AND tree = ? AND folderId = ?";

    private Delete() {
    }

    public static boolean deleteFolder(int cid, int tree, int user, String folderId, boolean global, boolean backup) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getWritable(cid);
        try {
            con.setAutoCommit(false);
            boolean ret = Delete.deleteFolder(cid, tree, user, folderId, global, backup, con);
            con.commit();
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteFolder(int cid, int tree, int user, String folderId, boolean global, boolean backup, Connection con) throws OXException {
        int pos;
        PreparedStatement stmt;
        block39: {
            org.apache.commons.logging.Log LOG;
            if (null == con) {
                return Delete.deleteFolder(cid, tree, user, folderId, global, backup);
            }
            stmt = null;
            if (!backup) break block39;
            try {
                stmt = con.prepareStatement(global ? SQL_GLOBAL_DELETE_INSERT : SQL_DELETE_INSERT);
                int pos2 = 1;
                stmt.setInt(pos2++, cid);
                stmt.setInt(pos2++, tree);
                if (!global) {
                    stmt.setInt(pos2++, user);
                }
                stmt.setString(pos2, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                block37: {
                    try {
                        Utility.debugSQL(stmt);
                        LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Delete.class));
                        if (!LOG.isDebugEnabled()) break block37;
                        LOG.debug((Object)"Backup failed.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(stmt);
                        throw throwable;
                    }
                }
                DBUtils.closeSQLStuff(stmt);
            }
            DBUtils.closeSQLStuff(stmt);
            try {
                stmt = con.prepareStatement(global ? SQL_GLOBAL_DELETE_INSERT_PERMS : SQL_DELETE_INSERT_PERMS);
                int pos3 = 1;
                stmt.setInt(pos3++, cid);
                stmt.setInt(pos3++, tree);
                if (!global) {
                    stmt.setInt(pos3++, user);
                }
                stmt.setString(pos3, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                Utility.debugSQL(stmt);
                LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Delete.class));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Backup failed.", (Throwable)e);
                }
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
            try {
                stmt = con.prepareStatement(global ? SQL_GLOBAL_DELETE_INSERT_SUBS : SQL_DELETE_INSERT_SUBS);
                int pos4 = 1;
                stmt.setInt(pos4++, cid);
                stmt.setInt(pos4++, tree);
                if (!global) {
                    stmt.setInt(pos4++, user);
                }
                stmt.setString(pos4, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                Utility.debugSQL(stmt);
                LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Delete.class));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Backup failed.", (Throwable)e);
                }
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
        }
        try {
            stmt = con.prepareStatement(global ? SQL_GLOBAL_DELETE_SUBS : SQL_DELETE_SUBS);
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            if (!global) {
                stmt.setInt(pos++, user);
            }
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Utility.debugSQL(stmt);
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        try {
            stmt = con.prepareStatement(global ? SQL_GLOBAL_DELETE_PERMS : SQL_DELETE_PERMS);
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            if (!global) {
                stmt.setInt(pos++, user);
            }
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            Utility.debugSQL(stmt);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        try {
            stmt = con.prepareStatement(global ? SQL_GLOBAL_DELETE : SQL_DELETE);
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            if (!global) {
                stmt.setInt(pos++, user);
            }
            stmt.setString(pos, folderId);
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            Utility.debugSQL(stmt);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

