/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class UnsubscribePerformer
extends AbstractPerformer {
    public UnsubscribePerformer(ServerSession session) {
        super(session);
    }

    public UnsubscribePerformer(User user, Context context) {
        super(user, context);
    }

    public UnsubscribePerformer(ServerSession session, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(session, folderStorageDiscoverer);
    }

    public UnsubscribePerformer(User user, Context context, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, folderStorageDiscoverer);
    }

    public void doUnsubscribe(String treeId, String folderId) throws OXException {
        if (KNOWN_TREES.contains(treeId)) {
            throw FolderExceptionErrorMessage.NO_REAL_UNSUBSCRIBE.create(treeId);
        }
        FolderStorage virtualStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, folderId);
        if (null == virtualStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
        if (virtualStorage.startTransaction(this.storageParameters, false)) {
            openedStorages.add(virtualStorage);
        }
        try {
            this.unsubscribeFolder(treeId, folderId, virtualStorage, true);
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(this.storageParameters);
            }
            Set<OXException> warnings = this.storageParameters.getWarnings();
            if (null != warnings) {
                for (OXException warning : warnings) {
                    this.addWarning(warning);
                }
            }
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private void unsubscribeFolder(String treeId, String folderId, FolderStorage virtualStorage, boolean allowSubfolderUnsubscribe) throws OXException {
        if (!virtualStorage.containsFolder(treeId, folderId, this.storageParameters)) {
            return;
        }
        Folder folder = virtualStorage.getFolder(treeId, folderId, this.storageParameters);
        Permission permission = CalculatePermission.calculate(folder, this, (List<ContentType>)ALL_ALLOWED);
        if (!permission.isVisible()) {
            throw FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.create(this.getFolderInfo4Error(folder), this.getUserInfo4Error(), this.getContextInfo4Error());
        }
        String[] ids = folder.getSubfolderIDs();
        if (null == ids) {
            SortableId[] sortableIds = virtualStorage.getSubfolders(treeId, folderId, this.storageParameters);
            if (sortableIds.length > 0) {
                if (!allowSubfolderUnsubscribe) {
                    throw FolderExceptionErrorMessage.NO_UNSUBSCRIBE.create(folderId, treeId);
                }
                for (SortableId sortableId : sortableIds) {
                    this.unsubscribeFolder(treeId, sortableId.getId(), virtualStorage, allowSubfolderUnsubscribe);
                }
            }
        } else if (ids.length > 0) {
            if (!allowSubfolderUnsubscribe) {
                throw FolderExceptionErrorMessage.NO_UNSUBSCRIBE.create(folderId, treeId);
            }
            for (String id : ids) {
                this.unsubscribeFolder(treeId, id, virtualStorage, allowSubfolderUnsubscribe);
            }
        }
        virtualStorage.deleteFolder(treeId, folderId, this.storageParameters);
    }
}

