/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.session.ServerSession;
import java.util.Set;

public final class ClearPerformer
extends AbstractPerformer {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ClearPerformer.class));

    public ClearPerformer(ServerSession session) {
        super(session);
    }

    public ClearPerformer(User user, Context context) {
        super(user, context);
    }

    public ClearPerformer(ServerSession session, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(session, folderStorageDiscoverer);
    }

    public ClearPerformer(User user, Context context, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, folderStorageDiscoverer);
    }

    public void doClear(String treeId, String folderId) throws OXException {
        FolderStorage folderStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        long start = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        boolean started = folderStorage.startTransaction(this.storageParameters, true);
        try {
            Set<OXException> warnings;
            folderStorage.clearFolder(treeId, folderId, this.storageParameters);
            if (LOG.isDebugEnabled()) {
                long duration = System.currentTimeMillis() - start;
                LOG.debug((Object)new StringAllocator().append("Clear.doClear() took ").append(duration).append("msec for folder: ").append(folderId).toString());
            }
            if (started) {
                folderStorage.commitTransaction(this.storageParameters);
            }
            if (null != (warnings = this.storageParameters.getWarnings())) {
                for (OXException warning : warnings) {
                    this.addWarning(warning);
                }
            }
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                folderStorage.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

