/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database.getfolder;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.LocalizedDatabaseFolder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import gnu.trove.list.array.TIntArrayList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public final class SystemPublicFolder {
    private SystemPublicFolder() {
    }

    public static DatabaseFolder getSystemPublicFolder(FolderObject fo) {
        LocalizedDatabaseFolder retval = new LocalizedDatabaseFolder(fo);
        retval.setName("Public folders");
        retval.setSubfolderIDs(null);
        retval.setSubscribedSubfolders(true);
        return retval;
    }

    public static int[] getSystemPublicFolderSubfoldersAsInt(User user, UserPermissionBits userConfiguration, Context ctx, Connection con) throws OXException {
        try {
            Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleSubfoldersIterator(2, user.getId(), user.getGroups(), ctx, userConfiguration, null, con)).asQueue();
            TIntArrayList subfolderIds = new TIntArrayList(q.size());
            subfolderIds.add(6);
            for (FolderObject folderObject : q) {
                subfolderIds.add(folderObject.getObjectID());
            }
            boolean tmp = OXFolderIteratorSQL.hasVisibleFoldersNotSeenInTreeView(2, user.getId(), user.getGroups(), userConfiguration, ctx, con);
            if (tmp) {
                subfolderIds.add(12);
            }
            if (tmp = OXFolderIteratorSQL.hasVisibleFoldersNotSeenInTreeView(3, user.getId(), user.getGroups(), userConfiguration, ctx, con)) {
                subfolderIds.add(13);
            }
            if (tmp = OXFolderIteratorSQL.hasVisibleFoldersNotSeenInTreeView(1, user.getId(), user.getGroups(), userConfiguration, ctx, con)) {
                subfolderIds.add(11);
            }
            return subfolderIds.toArray();
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
    }

    public static List<String[]> getSystemPublicFolderSubfolders(User user, UserPermissionBits userConfiguration, Context ctx, Connection con) throws OXException {
        try {
            Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleSubfoldersIterator(2, user.getId(), user.getGroups(), ctx, userConfiguration, null, con)).asQueue();
            ArrayList<String[]> subfolderIds = new ArrayList<String[]>(q.size());
            StringHelper sh = StringHelper.valueOf(user.getLocale());
            subfolderIds.add(SystemPublicFolder.toArray(String.valueOf(6), sh.getString("Global address book")));
            for (FolderObject folderObject : q) {
                subfolderIds.add(SystemPublicFolder.toArray(String.valueOf(folderObject.getObjectID()), folderObject.getFolderName()));
            }
            boolean tmp = OXFolderIteratorSQL.hasVisibleFoldersNotSeenInTreeView(2, user.getId(), user.getGroups(), userConfiguration, ctx, con);
            if (tmp) {
                subfolderIds.add(SystemPublicFolder.toArray(String.valueOf(12), sh.getString("Other calendar folders")));
            }
            if (tmp = OXFolderIteratorSQL.hasVisibleFoldersNotSeenInTreeView(3, user.getId(), user.getGroups(), userConfiguration, ctx, con)) {
                subfolderIds.add(SystemPublicFolder.toArray(String.valueOf(13), sh.getString("Other contact folders")));
            }
            if (tmp = OXFolderIteratorSQL.hasVisibleFoldersNotSeenInTreeView(1, user.getId(), user.getGroups(), userConfiguration, ctx, con)) {
                subfolderIds.add(SystemPublicFolder.toArray(String.valueOf(11), sh.getString("Other task folders")));
            }
            return subfolderIds;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static String[] toArray(String ... values) {
        int length = values.length;
        String[] ret = new String[length];
        System.arraycopy(values, 0, ret, 0, length);
        return values;
    }
}

