/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.lock;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class TreeLockManagement {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TreeLockManagement.class));
    private static final TreeLockManagement INSTANCE = new TreeLockManagement();
    private final ConcurrentMap<Integer, ConcurrentMap<Integer, ConcurrentMap<String, ReadWriteLock>>> map = new ConcurrentHashMap<Integer, ConcurrentMap<Integer, ConcurrentMap<String, ReadWriteLock>>>(32);

    public static TreeLockManagement getInstance() {
        return INSTANCE;
    }

    private TreeLockManagement() {
    }

    public void clear() {
        this.map.clear();
    }

    public void dropFor(Session session) {
        ConcurrentMap userMap = (ConcurrentMap)this.map.get(session.getContextId());
        if (null != userMap) {
            userMap.remove(session.getUserId());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)new StringAllocator("Cleaned folder locks for user ").append(session.getUserId()).append(" in context ").append(session.getContextId()).toString());
            }
        }
    }

    public void dropFor(int contextId) {
        this.map.remove(contextId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringAllocator("Cleaned folder locks for context ").append(contextId).toString());
        }
    }

    public ReadWriteLock getFor(String treeId, Session session) {
        return this.getFor(treeId, session.getUserId(), session.getContextId());
    }

    public ReadWriteLock getFor(String treeId, int userId, int contextId) {
        ReentrantReadWriteLock nrwl;
        ReadWriteLock readWriteLock;
        ConcurrentMap<String, ReentrantReadWriteLock> lockMap;
        ConcurrentMap userMap = (ConcurrentHashMap)this.map.get(contextId);
        if (null == userMap) {
            ConcurrentHashMap newUserMap = new ConcurrentHashMap(32);
            userMap = this.map.putIfAbsent(contextId, newUserMap);
            if (null == userMap) {
                userMap = newUserMap;
            }
        }
        if (null == (lockMap = (ConcurrentHashMap<String, ReentrantReadWriteLock>)userMap.get(userId))) {
            ConcurrentHashMap<String, ReentrantReadWriteLock> nlm = new ConcurrentHashMap<String, ReentrantReadWriteLock>(4);
            lockMap = userMap.putIfAbsent(userId, nlm);
            if (null == lockMap) {
                lockMap = nlm;
            }
        }
        if (null == (readWriteLock = (ReadWriteLock)lockMap.get(treeId)) && null == (readWriteLock = (ReadWriteLock)lockMap.putIfAbsent(treeId, nrwl = new ReentrantReadWriteLock()))) {
            readWriteLock = nrwl;
        }
        return readWriteLock;
    }

    public ReadWriteLock optFor(String treeId, Session session) {
        ConcurrentMap userMap = (ConcurrentMap)this.map.get(session.getContextId());
        if (null == userMap) {
            return null;
        }
        ConcurrentMap lockMap = (ConcurrentMap)userMap.get(session.getUserId());
        if (null == lockMap) {
            return null;
        }
        return (ReadWriteLock)lockMap.get(treeId);
    }
}

