/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage;

import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.java.StringAllocator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class StorageParametersUtility {
    private static final Set<String> BOOL_VALS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("true", "1", "yes", "y", "on")));

    private StorageParametersUtility() {
    }

    public static boolean isHandDownPermissions(StorageParameters params) {
        FolderServiceDecorator decorator = params.getDecorator();
        if (null == decorator) {
            return false;
        }
        Object permissionsHandling = decorator.getProperty("permissions");
        return null != permissionsHandling && "inherit".equalsIgnoreCase(permissionsHandling.toString());
    }

    public static boolean getBoolParameter(String name, StorageParameters params) {
        FolderServiceDecorator decorator = params.getDecorator();
        if (null == decorator) {
            return false;
        }
        Object tmp = decorator.getProperty(name);
        return null != tmp && (tmp instanceof Boolean ? (Boolean)tmp != false : StorageParametersUtility.parseBoolParameter(tmp.toString()));
    }

    public static boolean parseBoolParameter(String value) {
        return null != value && BOOL_VALS.contains(StorageParametersUtility.toLowerCase(value.trim()));
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }
}

