/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.event.impl;

import com.openexchange.event.impl.EventConfig;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.java.Streams;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class EventConfigImpl
extends AbstractConfigWrapper
implements EventConfig {
    private boolean isEventQueueEnabled;
    private int eventQueueDelay = 60000;
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(EventConfigImpl.class));

    public EventConfigImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventConfigImpl(File propfile) {
        if (propfile == null) {
            LOG.error((Object)"missing propfile");
            return;
        }
        Properties prop = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("try to load propfile: " + propfile));
            }
            prop = new Properties();
            FileInputStream in = new FileInputStream(propfile);
            try {
                prop.load(in);
            }
            finally {
                Streams.close((Closeable)in);
            }
        }
        catch (FileNotFoundException exc) {
            LOG.error((Object)("Cannot find propfile: " + propfile), (Throwable)exc);
        }
        catch (IOException exc) {
            LOG.error((Object)("Cannot read propfile: " + propfile), (Throwable)exc);
        }
        this.isEventQueueEnabled = EventConfigImpl.parseProperty(prop, "com.openexchange.event.isEventQueueEnabled", false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Event property: com.openexchange.event.isEventQueueEnabled=" + this.isEventQueueEnabled));
        }
        this.eventQueueDelay = EventConfigImpl.parseProperty(prop, "com.openexchange.event.eventQueueDelay", this.eventQueueDelay);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Event property: com.openexchange.event.eventQueueDelay=" + this.eventQueueDelay));
        }
    }

    @Override
    public boolean isEventQueueEnabled() {
        return this.isEventQueueEnabled;
    }

    @Override
    public void setEventQueueEnabled(boolean isEventQueueEnabled) {
        this.isEventQueueEnabled = isEventQueueEnabled;
    }

    @Override
    public int getEventQueueDelay() {
        return this.eventQueueDelay;
    }

    @Override
    public void setEventQueueDelay(int eventQueueDelay) {
        this.eventQueueDelay = eventQueueDelay;
    }
}

