/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.tx;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.provider.DBProviderUser;
import com.openexchange.database.provider.RequestDBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tx.TransactionAware;
import com.openexchange.tx.TransactionExceptionCodes;
import com.openexchange.tx.Undoable;
import com.openexchange.tx.UndoableAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;

public abstract class DBService
implements TransactionAware,
DBProviderUser,
DBProvider {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DBService.class));
    private RequestDBProvider provider;
    private final ThreadLocal<ThreadState> txState = new ThreadLocal();

    public DBProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(DBProvider provider) {
        this.provider = new RequestDBProvider(provider);
        this.provider.setTransactional(true);
    }

    public DBService() {
    }

    public DBService(DBProvider provider) {
        this.setProvider(provider);
    }

    @Override
    public Connection getReadConnection(Context ctx) throws OXException {
        ThreadState threadState = this.txState.get();
        if (threadState != null && threadState.preferWriteCon) {
            return this.getWriteConnection(ctx);
        }
        return this.provider.getReadConnection(ctx);
    }

    @Override
    public Connection getWriteConnection(Context ctx) throws OXException {
        Connection writeCon = this.provider.getWriteConnection(ctx);
        ThreadState threadState = this.txState.get();
        if (threadState != null && threadState.preferWriteCon) {
            threadState.writeCons.add(writeCon);
            return writeCon;
        }
        if (threadState != null) {
            threadState.preferWriteCon = true;
        }
        return writeCon;
    }

    @Override
    public void releaseReadConnection(Context ctx, Connection con) {
        ThreadState threadState = this.txState.get();
        if (threadState != null && threadState.preferWriteCon && threadState.writeCons.contains(con)) {
            this.releaseWriteConnection(ctx, con);
            return;
        }
        this.provider.releaseReadConnection(ctx, con);
    }

    @Override
    public void releaseWriteConnection(Context ctx, Connection con) {
        ThreadState threadState = this.txState.get();
        if (threadState != null && threadState.preferWriteCon) {
            threadState.writeCons.remove(con);
        }
        this.provider.releaseWriteConnection(ctx, con);
    }

    @Override
    public void releaseWriteConnectionAfterReading(Context ctx, Connection con) {
        ThreadState threadState = this.txState.get();
        if (threadState != null && threadState.preferWriteCon) {
            threadState.writeCons.remove(con);
        }
        this.provider.releaseWriteConnectionAfterReading(ctx, con);
    }

    public void commitDBTransaction() throws OXException {
        this.provider.commit();
    }

    public void commitDBTransaction(Undoable undo) throws OXException {
        this.provider.commit();
        this.addUndoable(undo);
    }

    public void rollbackDBTransaction() throws OXException {
        this.provider.rollback();
    }

    public void startDBTransaction() throws OXException {
        this.provider.startTransaction();
    }

    public void finishDBTransaction() throws OXException {
        this.provider.finish();
    }

    public void startTransaction() throws OXException {
        this.txState.set(new ThreadState());
    }

    public void finish() throws OXException {
        this.provider.finish();
        this.txState.set(null);
    }

    public void rollback() throws OXException {
        ThreadState threadState = this.txState.get();
        if (null == threadState) {
            return;
        }
        ArrayList<Undoable> undos = new ArrayList<Undoable>(threadState.undoables);
        if (undos.isEmpty()) {
            return;
        }
        LinkedList<Undoable> failed = new LinkedList<Undoable>();
        Collections.reverse(undos);
        for (Undoable undo : undos) {
            try {
                undo.undo();
            }
            catch (OXException x) {
                LOG.fatal((Object)x.getMessage(), (Throwable)x);
                failed.add(undo);
            }
        }
        if (!failed.isEmpty()) {
            OXException exception = TransactionExceptionCodes.NO_COMPLETE_ROLLBACK.create();
            if (LOG.isFatalEnabled()) {
                StringBuilder explanations = new StringBuilder();
                for (Undoable undo : failed) {
                    explanations.append(undo.error());
                    explanations.append('\n');
                }
                LOG.fatal((Object)explanations.toString(), (Throwable)exception);
            }
            throw exception;
        }
    }

    public void commit() throws OXException {
    }

    public void setRequestTransactional(boolean transactional) {
        this.provider.setRequestTransactional(transactional);
    }

    public void setCommitsTransaction(boolean mustCommit) {
        this.provider.setCommitsTransaction(false);
    }

    protected void close(PreparedStatement stmt, ResultSet rs) {
        DBUtils.closeSQLStuff(rs, stmt);
    }

    protected void addUndoable(Undoable undo) {
        ThreadState threadState = this.txState.get();
        if (null == threadState || null == threadState.undoables) {
            return;
        }
        threadState.undoables.add(undo);
    }

    protected void perform(UndoableAction action, boolean dbTransaction) throws OXException {
        try {
            if (dbTransaction) {
                this.startDBTransaction();
            }
            action.perform();
            if (dbTransaction) {
                this.commitDBTransaction((Undoable)action);
            } else {
                this.addUndoable((Undoable)action);
            }
        }
        catch (OXException e) {
            if (dbTransaction) {
                try {
                    this.rollbackDBTransaction();
                }
                catch (OXException x) {
                    x.log(LOG);
                }
            }
            throw e;
        }
        finally {
            if (dbTransaction) {
                try {
                    this.finishDBTransaction();
                }
                catch (OXException x) {
                    x.log(LOG);
                }
            }
        }
    }

    @Deprecated
    public void setTransactional(boolean tx) {
    }

    public boolean inTransaction() {
        return this.txState.get() != null;
    }

    private static final class ThreadState {
        protected final List<Undoable> undoables = new ArrayList<Undoable>();
        protected boolean preferWriteCon;
        protected final Set<Connection> writeCons = new HashSet<Connection>();

        protected ThreadState() {
        }
    }
}

