/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.provider;

import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.Streams;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RequestDBProvider
implements DBProvider {
    private static final ThreadLocal<DBTransaction> txIds = new ThreadLocal();
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(RequestDBProvider.class));
    private boolean commits = true;
    private final ThreadLocal<Integer> readCount = new ThreadLocal<Integer>(){

        @Override
        protected final Integer initialValue() {
            return 0;
        }
    };
    private boolean transactional;
    private DBProvider provider;

    public RequestDBProvider() {
    }

    public RequestDBProvider(DBProvider provider) {
        this.setProvider(provider);
    }

    public DBProvider getProvider() {
        return this.provider;
    }

    public void setProvider(DBProvider provider) {
        this.provider = provider;
    }

    public void startTransaction() throws OXException {
        DBTransaction tx = this.createTransaction();
        tx.transactional = this.transactional;
        tx.commit = this.commits;
        txIds.set(tx);
    }

    public void commit() throws OXException {
        this.checkThreadDeath();
        this.commit(this.getActiveTransaction());
    }

    private void checkThreadDeath() {
    }

    public void rollback() throws OXException {
        this.rollback(this.getActiveTransaction());
    }

    protected DBTransaction getActiveTransaction() {
        return txIds.get();
    }

    protected DBTransaction createTransaction() {
        DBTransaction tx = new DBTransaction();
        return tx;
    }

    protected void commit(DBTransaction tx) throws OXException {
        try {
            if (tx.writeConnection != null && !tx.writeConnection.getAutoCommit() && tx.commit) {
                tx.writeConnection.commit();
            }
        }
        catch (SQLException e) {
            throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[0]);
        }
    }

    protected void rollback(DBTransaction tx) throws OXException {
        if (tx == null) {
            return;
        }
        try {
            if (tx.writeConnection != null) {
                if (tx.writeConnection.getAutoCommit()) {
                    throw new IllegalStateException("This request cannot be rolled back because it wasn't part of a transaction");
                }
                tx.writeConnection.rollback();
            }
        }
        catch (SQLException e) {
            throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[0]);
        }
    }

    @Override
    public Connection getReadConnection(Context ctx) throws OXException {
        this.checkThreadDeath();
        DBTransaction tx = this.getActiveTransaction();
        int rc = this.readCount.get();
        if (tx != null && tx.ctx == null) {
            tx.ctx = ctx;
        }
        if (tx != null && tx.writeConnection != null) {
            return tx.writeConnection;
        }
        if (tx != null && tx.readConnection != null) {
            Throwable t = new Throwable();
            t.fillInStackTrace();
            tx.readConnectionStacks.set(++rc, t);
            this.readCount.set(rc);
            return tx.readConnection;
        }
        Connection readCon = this.getProvider().getReadConnection(ctx);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("---> " + readCon));
        }
        if (tx != null) {
            tx.readConnection = readCon;
            Throwable t = new Throwable();
            t.fillInStackTrace();
            tx.readConnectionStacks.set(++rc, t);
            this.readCount.set(rc);
        }
        return readCon;
    }

    @Override
    public Connection getWriteConnection(Context ctx) throws OXException {
        this.checkThreadDeath();
        DBTransaction tx = this.getActiveTransaction();
        if (tx == null) {
            return this.getProvider().getWriteConnection(ctx);
        }
        int rc = this.readCount.get();
        if (rc > 0) {
            throw new IllegalStateException("Don't use a read and write connection in parallel. Read Connections in use: " + rc, tx.readConnectionStacks.get(rc));
        }
        if (tx.writeConnection != null) {
            return tx.writeConnection;
        }
        tx.writeConnection = this.getProvider().getWriteConnection(ctx);
        try {
            tx.autoCommit = tx.writeConnection.getAutoCommit();
            if (tx.writeConnection.getAutoCommit() == tx.transactional) {
                tx.writeConnection.setAutoCommit(!tx.transactional);
            }
        }
        catch (SQLException e) {
            return null;
        }
        if (tx != null && tx.ctx == null) {
            tx.ctx = ctx;
        }
        return tx.writeConnection;
    }

    @Override
    public void releaseReadConnection(Context ctx, Connection con) {
        DBTransaction tx = this.getActiveTransaction();
        if (tx != null && tx.writeConnection != null && tx.writeConnection.equals(con)) {
            return;
        }
        if (tx != null && tx.readConnection != null && tx.readConnection.equals(con)) {
            int rc = this.readCount.get();
            if (--rc == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("<--- " + con));
                }
                this.getProvider().releaseReadConnection(ctx, con);
                tx.readConnection = null;
            }
            this.readCount.set(rc);
            return;
        }
        if (tx != null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<--- " + con));
        }
        this.getProvider().releaseReadConnection(ctx, con);
    }

    @Override
    public void releaseWriteConnection(Context ctx, Connection con) {
        DBTransaction tx = this.getActiveTransaction();
        if (tx == null) {
            this.getProvider().releaseWriteConnection(ctx, con);
        }
    }

    @Override
    public void releaseWriteConnectionAfterReading(Context ctx, Connection con) {
        DBTransaction tx = this.getActiveTransaction();
        if (tx == null) {
            this.getProvider().releaseWriteConnectionAfterReading(ctx, con);
        }
    }

    public void finish() throws OXException {
        DBTransaction tx = this.getActiveTransaction();
        if (tx == null) {
            return;
        }
        try {
            if (tx.writeConnection != null) {
                if (tx.writeConnection.getAutoCommit() != tx.autoCommit) {
                    tx.writeConnection.setAutoCommit(tx.autoCommit);
                }
                this.getProvider().releaseWriteConnection(tx.ctx, tx.writeConnection);
                tx.writeConnection = null;
            }
            if (tx.readConnection != null) {
                this.getProvider().releaseReadConnection(tx.ctx, tx.readConnection);
                this.readCount.set(0);
                tx.readConnection = null;
            }
        }
        catch (SQLException e) {
            throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[0]);
        }
        txIds.set(null);
        DBProvider prov = this.getProvider();
        if (prov instanceof Closeable) {
            Streams.close((Closeable)((Closeable)((Object)prov)));
        }
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isTransactional() {
        DBTransaction tx = this.getActiveTransaction();
        if (tx != null && tx.transactional) {
            return true;
        }
        return this.transactional;
    }

    public void setRequestTransactional(boolean transactional) {
        DBTransaction tx = this.getActiveTransaction();
        if (tx == null) {
            throw new IllegalStateException("No Transaction Active");
        }
        if (tx.writeConnection != null && transactional) {
            throw new IllegalStateException("Cannot switch on transaction after a write occurred");
        }
        tx.transactional = transactional;
    }

    public void setCommitsTransaction(boolean commits) {
        this.commits = commits;
    }

    public static class DBTransaction {
        public Connection writeConnection;
        public Connection readConnection;
        public Context ctx;
        public boolean transactional;
        List<Throwable> readConnectionStacks = new ArrayList<Throwable>();
        public boolean autoCommit;
        public boolean commit = true;

        public DBTransaction() {
            for (int i = 0; i < 10; ++i) {
                this.readConnectionStacks.add(null);
            }
        }
    }
}

