/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.contact.SortOptions;
import com.openexchange.contact.internal.Check;
import com.openexchange.contact.internal.ContactServiceLookup;
import com.openexchange.contact.internal.DefaultContactService;
import com.openexchange.contact.internal.QueryFields;
import com.openexchange.contact.internal.ResultIterator;
import com.openexchange.contact.internal.SearchTermAnalyzer;
import com.openexchange.contact.internal.Tools;
import com.openexchange.contact.internal.mapping.ContactMapper;
import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.ContactMergerator;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.SingleSearchTerm;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ContactServiceImpl
extends DefaultContactService {
    @Override
    protected void doCreateContact(Session session, String folderID, Contact contact) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactStorage storage = Tools.getStorage(session, folderID);
        Check.validateProperties(contact);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, userID);
        Check.canCreateObjects(permission, session, folderID);
        FolderObject folder = Tools.getFolder(contextID, folderID);
        Check.isContactFolder(folder, session);
        Check.noPrivateInPublic(folder, contact, session);
        Check.canWriteInGAB(storage, session, folderID, contact);
        Date now = new Date();
        contact.setParentFolderID(Tools.parse(folderID));
        contact.setContextId(contextID);
        contact.setLastModified(now);
        contact.setCreationDate(now);
        contact.setCreatedBy(userID);
        contact.setModifiedBy(userID);
        contact.removeObjectID();
        contact.setNumberOfAttachments(0);
        if (contact.containsImage1()) {
            contact.setImageLastModified(now);
            if (null != contact.getImage1()) {
                contact.setNumberOfImages(1);
            } else {
                contact.setNumberOfImages(0);
                contact.setImageContentType(null);
            }
        }
        if (!contact.containsUid() || Tools.isEmpty(contact.getUid())) {
            contact.setUid(UUID.randomUUID().toString());
        }
        if (!contact.containsFileAs() && contact.containsDisplayName()) {
            contact.setFileAs(contact.getDisplayName());
        }
        storage.create(session, folderID, contact);
        new EventClient(session).create(contact, folder);
    }

    @Override
    protected void doUpdateAndMoveContact(Session session, String sourceFolderId, String targetFolderId, String objectID, Contact contact, Date lastRead) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactMapper.getInstance().validateAll(contact);
        if (contact.containsObjectID() && contact.getObjectID() > 0 && !Integer.toString(contact.getObjectID()).equals(objectID)) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        FolderObject sourceFolder = Tools.getFolder(contextID, sourceFolderId);
        Check.isContactFolder(sourceFolder, session);
        EffectivePermission sourceFolderPermission = Tools.getPermission(contextID, sourceFolderId, userID);
        Check.canDeleteOwn(sourceFolderPermission, session, sourceFolderId);
        FolderObject targetFolder = Tools.getFolder(contextID, targetFolderId);
        Check.isContactFolder(targetFolder, session);
        Check.noPrivateInPublic(targetFolder, contact, session);
        EffectivePermission targetFolderPermission = Tools.getPermission(contextID, targetFolderId, userID);
        Check.canCreateObjects(targetFolderPermission, session, targetFolderId);
        ContactStorage sourceStorage = Tools.getStorage(session, sourceFolderId);
        Contact storedContact = sourceStorage.get(session, sourceFolderId, objectID, ContactField.values());
        Check.contactNotNull(storedContact, contextID, Tools.parse(objectID));
        if (storedContact.getCreatedBy() != userID) {
            Check.canDeleteAll(sourceFolderPermission, session, sourceFolderId);
        }
        Check.lastModifiedBefore(storedContact, lastRead);
        Check.folderEquals(storedContact, sourceFolderId, contextID);
        Contact delta = (Contact)ContactMapper.getInstance().getDifferences(storedContact, contact);
        Check.readOnlyFields(userID, storedContact, delta);
        Date now = new Date();
        delta.setLastModified(now);
        delta.setModifiedBy(userID);
        delta.setParentFolderID(Tools.parse(targetFolderId));
        if (!(storedContact.containsUid() && !Tools.isEmpty(storedContact.getUid()) || delta.containsUid())) {
            delta.setUid(UUID.randomUUID().toString());
        }
        if (delta.containsImage1()) {
            delta.setImageLastModified(now);
            if (null != delta.getImage1()) {
                delta.setNumberOfImages(1);
            } else {
                delta.setNumberOfImages(0);
                delta.setImageContentType(null);
            }
        }
        Tools.invalidateAddressesIfNeeded(delta);
        Tools.setFileAsIfNeeded(delta);
        Contact updatedContact = new Contact();
        ContactMapper.getInstance().mergeDifferences(updatedContact, storedContact);
        ContactMapper.getInstance().mergeDifferences(updatedContact, delta);
        ContactStorage targetStorage = Tools.getStorage(session, targetFolderId);
        if (sourceStorage.equals(targetStorage)) {
            sourceStorage.update(session, sourceFolderId, objectID, delta, lastRead);
            ContactMapper.getInstance().mergeDifferences(contact, delta);
        } else {
            targetStorage.create(session, targetFolderId, updatedContact);
            ContactMapper.getInstance().mergeDifferences(contact, updatedContact);
            try {
                sourceStorage.delete(session, sourceFolderId, objectID, lastRead);
            }
            catch (OXException e) {
                LOG.warn((Object)"error deleting contact from source folder, rolling back move operation", (Throwable)e);
                targetStorage.delete(session, targetFolderId, Integer.toString(storedContact.getObjectID()), storedContact.getLastModified());
                throw e;
            }
        }
        for (ContactStorage contactStorage : Tools.getStorages(session)) {
            contactStorage.updateReferences(session, storedContact, updatedContact);
        }
        new EventClient(session).modify(storedContact, updatedContact, targetFolder);
    }

    @Override
    protected void doUpdateContact(Session session, String folderID, String objectID, Contact contact, Date lastRead) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactStorage storage = Tools.getStorage(session, folderID);
        Check.validateProperties(contact);
        if (contact.containsObjectID() && contact.getObjectID() > 0 && !Integer.toString(contact.getObjectID()).equals(objectID)) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        EffectivePermission permission = Tools.getPermission(contextID, folderID, userID);
        Check.canWriteOwn(permission, session);
        Contact storedContact = storage.get(session, folderID, objectID, ContactField.values());
        Check.contactNotNull(storedContact, contextID, Tools.parse(objectID));
        if (storedContact.getCreatedBy() != userID) {
            Check.canWriteAll(permission, session);
        }
        Check.lastModifiedBefore(storedContact, lastRead);
        Check.folderEquals(storedContact, folderID, contextID);
        FolderObject folder = Tools.getFolder(contextID, folderID);
        Check.isContactFolder(folder, session);
        Check.noPrivateInPublic(folder, contact, session);
        Check.canWriteInGAB(storage, session, folderID, contact);
        Contact delta = (Contact)ContactMapper.getInstance().getDifferences(storedContact, contact);
        Check.readOnlyFields(userID, storedContact, delta);
        if (delta.containsParentFolderID()) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        Date now = new Date();
        delta.setLastModified(now);
        delta.setModifiedBy(userID);
        if (!(storedContact.containsUid() && !Tools.isEmpty(storedContact.getUid()) || delta.containsUid())) {
            delta.setUid(UUID.randomUUID().toString());
        }
        if (delta.containsImage1()) {
            delta.setImageLastModified(now);
            if (null != delta.getImage1()) {
                delta.setNumberOfImages(1);
            } else {
                delta.setNumberOfImages(0);
                delta.setImageContentType(null);
            }
        }
        Tools.invalidateAddressesIfNeeded(delta);
        Tools.setFileAsIfNeeded(delta);
        Contact updatedContact = new Contact();
        ContactMapper.getInstance().mergeDifferences(updatedContact, storedContact);
        ContactMapper.getInstance().mergeDifferences(updatedContact, delta);
        storage.update(session, folderID, objectID, delta, lastRead);
        ContactMapper.getInstance().mergeDifferences(contact, delta);
        for (ContactStorage contactStorage : Tools.getStorages(session)) {
            contactStorage.updateReferences(session, storedContact, updatedContact);
        }
        new EventClient(session).modify(storedContact, updatedContact, folder);
    }

    @Override
    protected void doUpdateUser(Session session, String folderID, String objectID, Contact contact, Date lastRead) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactStorage storage = Tools.getStorage(session, folderID);
        Check.validateProperties(contact);
        if (contact.containsObjectID() && contact.getObjectID() > 0 && !Integer.toString(contact.getObjectID()).equals(objectID)) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        if (6 != Tools.parse(folderID) || contact.containsParentFolderID() && 0 < contact.getParentFolderID() && 6 != contact.getParentFolderID()) {
            throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(6, contextID, userID);
        }
        Contact storedContact = storage.get(session, folderID, objectID, ContactField.values());
        Check.contactNotNull(storedContact, contextID, Tools.parse(objectID));
        if (storedContact.getCreatedBy() != userID) {
            if (storedContact.getCreatedBy() == Tools.getContext(contextID).getContextId()) {
                contact.setCreatedBy(contact.getInternalUserId());
            } else {
                throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
            }
        }
        Check.lastModifiedBefore(storedContact, lastRead);
        Check.folderEquals(storedContact, folderID, contextID);
        Check.canWriteInGAB(storage, session, folderID, contact);
        Contact delta = (Contact)ContactMapper.getInstance().getDifferences(storedContact, contact);
        Check.readOnlyFields(userID, storedContact, delta);
        if (delta.containsParentFolderID()) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Tools.parse(objectID), contextID);
        }
        Date now = new Date();
        delta.setLastModified(now);
        delta.setModifiedBy(userID);
        if (!(storedContact.containsUid() && !Tools.isEmpty(storedContact.getUid()) || delta.containsUid())) {
            delta.setUid(UUID.randomUUID().toString());
        }
        if (delta.containsImage1()) {
            delta.setImageLastModified(now);
            if (null != delta.getImage1()) {
                delta.setNumberOfImages(1);
            } else {
                delta.setNumberOfImages(0);
                delta.setImageContentType(null);
            }
        }
        Tools.invalidateAddressesIfNeeded(delta);
        Tools.setFileAsIfNeeded(delta);
        Contact updatedContact = new Contact();
        ContactMapper.getInstance().mergeDifferences(updatedContact, storedContact);
        ContactMapper.getInstance().mergeDifferences(updatedContact, delta);
        storage.update(session, folderID, objectID, delta, lastRead);
        ContactMapper.getInstance().mergeDifferences(contact, delta);
        for (ContactStorage contactStorage : Tools.getStorages(session)) {
            contactStorage.updateReferences(session, storedContact, updatedContact);
        }
        new EventClient(session).modify(storedContact, updatedContact, Tools.getFolder(contextID, folderID));
    }

    @Override
    protected void doDeleteContact(Session session, String folderID, String objectID, Date lastRead) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactStorage storage = Tools.getStorage(session, folderID);
        FolderObject folder = Tools.getFolder(contextID, folderID);
        Check.isContactFolder(folder, session);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, userID);
        Check.canDeleteOwn(permission, session, folderID);
        Contact storedContact = storage.get(session, folderID, objectID, new ContactField[]{ContactField.CREATED_BY, ContactField.LAST_MODIFIED});
        Check.contactNotNull(storedContact, contextID, Tools.parse(objectID));
        if (storedContact.getCreatedBy() != userID) {
            Check.canDeleteAll(permission, session, folderID);
        }
        Check.lastModifiedBefore(storedContact, lastRead);
        storage.delete(session, folderID, objectID, lastRead);
        storedContact.setContextId(contextID);
        storedContact.setParentFolderID(Tools.parse(folderID));
        storedContact.setObjectID(Tools.parse(objectID));
        new EventClient(session).delete(storedContact, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDeleteContacts(Session session, String folderID, String[] objectIDs, Date lastRead) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactStorage storage = Tools.getStorage(session, folderID);
        FolderObject folder = Tools.getFolder(contextID, folderID);
        Check.isContactFolder(folder, session);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, userID);
        Check.canDeleteOwn(permission, session, folderID);
        SearchIterator<Contact> searchIterator = null;
        ArrayList<Contact> storedContacts = new ArrayList<Contact>();
        try {
            searchIterator = storage.list(session, folderID, objectIDs, new ContactField[]{ContactField.CREATED_BY, ContactField.LAST_MODIFIED, ContactField.OBJECT_ID});
            while (searchIterator.hasNext()) {
                Contact storedContact = (Contact)searchIterator.next();
                if (storedContact.getCreatedBy() != userID) {
                    Check.canDeleteAll(permission, session, folderID);
                }
                Check.lastModifiedBefore(storedContact, lastRead);
                storedContacts.add(storedContact);
            }
        }
        finally {
            Tools.close(searchIterator);
        }
        for (String objectID : objectIDs) {
            boolean found = false;
            for (Contact contact : storedContacts) {
                if (contact.getObjectID() != Tools.parse(objectID)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw ContactExceptionCodes.CONTACT_NOT_FOUND.create(Tools.parse(objectID), contextID);
        }
        storage.delete(session, folderID, objectIDs, lastRead);
        EventClient eventClient = new EventClient(session);
        for (Contact storedContact : storedContacts) {
            storedContact.setContextId(contextID);
            storedContact.setParentFolderID(Tools.parse(folderID));
            storedContact.setObjectID(storedContact.getObjectID());
            eventClient.delete(storedContact, folder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDeleteContacts(Session session, String folderID) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        ContactStorage storage = Tools.getStorage(session, folderID);
        FolderObject folder = Tools.getFolder(contextID, folderID);
        Check.isContactFolder(folder, session);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, userID);
        Check.canDeleteAll(permission, session, folderID);
        ArrayList<Contact> storedContacts = new ArrayList<Contact>();
        SearchIterator<Contact> searchIterator = null;
        try {
            searchIterator = storage.all(session, folderID, new ContactField[]{ContactField.CREATED_BY, ContactField.OBJECT_ID});
            if (null != searchIterator) {
                while (searchIterator.hasNext()) {
                    Contact storedContact = (Contact)searchIterator.next();
                    storedContacts.add(storedContact);
                }
            }
        }
        finally {
            Tools.close(searchIterator);
        }
        storage.delete(session, folderID);
        EventClient eventClient = new EventClient(session);
        Date now = new Date();
        for (Contact contact : storedContacts) {
            contact.setContextId(contextID);
            contact.setParentFolderID(Tools.parse(folderID));
            contact.setLastModified(now);
            contact.setModifiedBy(userID);
            eventClient.delete(contact, folder);
        }
    }

    @Override
    protected <O> SearchIterator<Contact> doGetContacts(boolean deleted, Session session, String folderID, String[] ids, ContactField[] fields, SortOptions sortOptions, Date since) throws OXException {
        int contextID = session.getContextId();
        FolderObject folder = Tools.getFolder(contextID, folderID);
        Check.isContactFolder(folder, session);
        EffectivePermission permission = Tools.getPermission(session, folder);
        Check.canReadOwn(permission, session, folderID);
        QueryFields queryFields = new QueryFields(fields);
        if (null == sortOptions) {
            sortOptions = SortOptions.EMPTY;
        }
        ContactStorage storage = Tools.getStorage(session, folderID);
        SearchIterator<Contact> contacts2 = null;
        contacts2 = null != since ? (deleted ? storage.deleted(session, folderID, since, queryFields.getFields(), sortOptions) : storage.modified(session, folderID, since, queryFields.getFields(), sortOptions)) : (null != ids ? storage.list(session, folderID, ids, queryFields.getFields(), sortOptions) : storage.all(session, folderID, queryFields.getFields(), sortOptions));
        if (null == contacts2) {
            throw ContactExceptionCodes.UNEXPECTED_ERROR.create("got no results from storage");
        }
        return new ResultIterator(contacts2, queryFields.needsAttachmentInfo(), session, permission.canReadAllObjects());
    }

    @Override
    protected SearchIterator<Contact> doGetContacts(final Session session, List<String> folderIDs, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int contextID = session.getContextId();
        int userID = session.getUserId();
        if (null != folderIDs) {
            for (String folderID : folderIDs) {
                FolderObject folder = Tools.getFolder(contextID, folderID);
                Check.isContactFolder(folder, session);
                EffectivePermission permission = Tools.getPermission(session, folder);
                Check.canReadOwn(permission, session, folderID);
            }
        }
        Map<ContactStorage, List<String>> queriedStorages = Tools.getStorages(session, null == folderIDs ? Tools.getVisibleFolders(contextID, userID) : folderIDs);
        Check.hasStorages(queriedStorages);
        final QueryFields queryFields = new QueryFields(fields);
        final SortOptions sOptions = null != sortOptions ? sortOptions : SortOptions.EMPTY;
        ArrayList<AbstractTask<SearchIterator<Contact>>> tasks2 = new ArrayList<AbstractTask<SearchIterator<Contact>>>(queriedStorages.size());
        for (final Map.Entry<ContactStorage, List<String>> queriedStorage : queriedStorages.entrySet()) {
            if (1 == queriedStorage.getValue().size()) {
                tasks2.add(new AbstractTask<SearchIterator<Contact>>(){

                    public SearchIterator<Contact> call() throws Exception {
                        return ((ContactStorage)queriedStorage.getKey()).all(session, (String)((List)queriedStorage.getValue()).get(0), queryFields.getFields(), sOptions);
                    }
                });
                continue;
            }
            final CompositeSearchTerm folderIDsTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.OR);
            for (String folderID : queriedStorage.getValue()) {
                folderIDsTerm.addSearchTerm(Tools.createContactFieldTerm(ContactField.FOLDER_ID, SingleSearchTerm.SingleOperation.EQUALS, folderID));
            }
            tasks2.add(new AbstractTask<SearchIterator<Contact>>(){

                public SearchIterator<Contact> call() throws Exception {
                    return ((ContactStorage)queriedStorage.getKey()).search(session, folderIDsTerm, queryFields.getFields(), sOptions);
                }
            });
        }
        return ContactServiceImpl.perform(tasks2, session, queryFields.needsAttachmentInfo(), sOptions);
    }

    @Override
    protected <O> SearchIterator<Contact> doSearchContacts(final Session session, SearchTerm<O> term, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        SearchTermAnalyzer termAnanlyzer = new SearchTermAnalyzer(term);
        Map<ContactStorage, List<String>> queriedStorages = Tools.getStorages(session, termAnanlyzer.hasFolderIDs() ? termAnanlyzer.getFolderIDs() : Tools.getSearchFolders(contextID, userID, false));
        Check.hasStorages(queriedStorages);
        final QueryFields queryFields = new QueryFields(fields);
        final SortOptions sOptions = null != sortOptions ? sortOptions : SortOptions.EMPTY;
        ArrayList<AbstractTask<SearchIterator<Contact>>> tasks2 = new ArrayList<AbstractTask<SearchIterator<Contact>>>(queriedStorages.size());
        for (final Map.Entry<ContactStorage, List<String>> queriedStorage : queriedStorages.entrySet()) {
            CompositeSearchTerm searchTerm;
            if (termAnanlyzer.hasFolderIDs()) {
                searchTerm = term;
            } else {
                CompositeSearchTerm combinedTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
                combinedTerm.addSearchTerm(Tools.getFoldersTerm(queriedStorage.getValue()));
                combinedTerm.addSearchTerm(term);
                searchTerm = combinedTerm;
            }
            tasks2.add(new AbstractTask<SearchIterator<Contact>>(){

                public SearchIterator<Contact> call() throws Exception {
                    return ((ContactStorage)queriedStorage.getKey()).search(session, searchTerm, queryFields.getFields(), sOptions);
                }
            });
        }
        return ContactServiceImpl.perform(tasks2, session, queryFields.needsAttachmentInfo(), sOptions);
    }

    @Override
    protected SearchIterator<Contact> doSearchContacts(final Session session, final ContactSearchObject contactSearch, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        Check.validateSearch(contactSearch);
        Map<ContactStorage, List<String>> queriedStorages = Tools.getStorages(session, contactSearch.hasFolders() ? Tools.toStringList(contactSearch.getFolders()) : Tools.getSearchFolders(contextID, userID, contactSearch.isEmailAutoComplete()));
        Check.hasStorages(queriedStorages);
        final QueryFields queryFields = new QueryFields(fields);
        final SortOptions sOptions = null != sortOptions ? sortOptions : SortOptions.EMPTY;
        ArrayList<AbstractTask<SearchIterator<Contact>>> tasks2 = new ArrayList<AbstractTask<SearchIterator<Contact>>>(queriedStorages.size());
        for (final Map.Entry<ContactStorage, List<String>> queriedStorage : queriedStorages.entrySet()) {
            tasks2.add(new AbstractTask<SearchIterator<Contact>>(){

                public SearchIterator<Contact> call() throws Exception {
                    return ((ContactStorage)queriedStorage.getKey()).search(session, Tools.prepareContactSearch(contactSearch, (List)queriedStorage.getValue()), queryFields.getFields(), sOptions);
                }
            });
        }
        return ContactServiceImpl.perform(tasks2, session, queryFields.needsAttachmentInfo(), sOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doGetOrganization(Session session) throws OXException {
        int userID = Tools.getContext(session).getMailadmin();
        String folderID = Integer.toString(6);
        ContactStorage storage = Tools.getStorage(session, folderID);
        CompositeSearchTerm searchTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
        searchTerm.addSearchTerm(Tools.createContactFieldTerm(ContactField.FOLDER_ID, SingleSearchTerm.SingleOperation.EQUALS, folderID));
        searchTerm.addSearchTerm(Tools.createContactFieldTerm(ContactField.INTERNAL_USERID, SingleSearchTerm.SingleOperation.EQUALS, userID));
        Contact contact = null;
        SearchIterator<Contact> searchIterator = null;
        try {
            searchIterator = storage.search(session, searchTerm, new ContactField[]{ContactField.COMPANY});
            if (null != searchIterator && searchIterator.hasNext()) {
                contact = (Contact)searchIterator.next();
            }
        }
        finally {
            Tools.close(searchIterator);
        }
        Check.contactNotNull(contact, session.getContextId(), userID);
        return contact.getCompany();
    }

    @Override
    protected <O> SearchIterator<Contact> doGetUsers(Session session, int[] userIDs, SearchTerm<O> term, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int currentUserID = session.getUserId();
        int contextID = session.getContextId();
        String folderID = Integer.toString(6);
        ContactStorage storage = Tools.getStorage(session, folderID);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, currentUserID);
        QueryFields queryFields = permission.canReadAllObjects() || null != userIDs && 1 == userIDs.length && currentUserID == userIDs[0] ? new QueryFields(fields) : new QueryFields(fields, LIMITED_USER_FIELDS);
        if (null == sortOptions) {
            sortOptions = SortOptions.EMPTY;
        }
        CompositeSearchTerm searchTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
        searchTerm.addSearchTerm(Tools.createContactFieldTerm(ContactField.FOLDER_ID, SingleSearchTerm.SingleOperation.EQUALS, folderID));
        if (null == userIDs || 0 == userIDs.length) {
            searchTerm.addSearchTerm(Tools.createContactFieldTerm(ContactField.INTERNAL_USERID, SingleSearchTerm.SingleOperation.GREATER_THAN, 0));
        } else if (null != userIDs && 1 == userIDs.length) {
            searchTerm.addSearchTerm(Tools.createContactFieldTerm(ContactField.INTERNAL_USERID, SingleSearchTerm.SingleOperation.EQUALS, userIDs[0]));
        } else {
            CompositeSearchTerm userIDsTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.OR);
            for (int userID : userIDs) {
                userIDsTerm.addSearchTerm(Tools.createContactFieldTerm(ContactField.INTERNAL_USERID, SingleSearchTerm.SingleOperation.EQUALS, userID));
            }
            searchTerm.addSearchTerm(userIDsTerm);
        }
        if (null != term) {
            searchTerm.addSearchTerm(term);
        }
        return new ResultIterator(storage.search(session, searchTerm, queryFields.getFields(), sortOptions), queryFields.needsAttachmentInfo(), session, true);
    }

    @Override
    protected SearchIterator<Contact> doGetUsers(Session session, int[] userIDs, ContactSearchObject contactSearch, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int currentUserID = session.getUserId();
        int contextID = session.getContextId();
        String folderID = Integer.toString(6);
        ContactStorage storage = Tools.getStorage(session, folderID);
        EffectivePermission permission = Tools.getPermission(contextID, folderID, currentUserID);
        QueryFields queryFields = permission.canReadAllObjects() || null != userIDs && 1 == userIDs.length && currentUserID == userIDs[0] ? new QueryFields(fields) : new QueryFields(fields, LIMITED_USER_FIELDS);
        if (null == sortOptions) {
            sortOptions = SortOptions.EMPTY;
        }
        return new ResultIterator(storage.search(session, contactSearch, queryFields.getFields(), sortOptions), queryFields.needsAttachmentInfo(), session, true);
    }

    @Override
    protected SearchIterator<Contact> doSearchContactsWithBirthday(final Session session, final Date from, final Date until, List<String> folderIDs, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        Map<ContactStorage, List<String>> queriedStorages = Tools.getStorages(session, null == folderIDs ? Tools.getVisibleFolders(contextID, userID) : folderIDs);
        Check.hasStorages(queriedStorages);
        final QueryFields queryFields = new QueryFields(fields);
        final SortOptions sOptions = null != sortOptions ? sortOptions : SortOptions.EMPTY;
        ArrayList<AbstractTask<SearchIterator<Contact>>> tasks2 = new ArrayList<AbstractTask<SearchIterator<Contact>>>(queriedStorages.size());
        for (final Map.Entry<ContactStorage, List<String>> queriedStorage : queriedStorages.entrySet()) {
            tasks2.add(new AbstractTask<SearchIterator<Contact>>(){

                public SearchIterator<Contact> call() throws Exception {
                    return ((ContactStorage)queriedStorage.getKey()).searchByBirthday(session, (List)queriedStorage.getValue(), from, until, queryFields.getFields(), sOptions);
                }
            });
        }
        return ContactServiceImpl.perform(tasks2, session, queryFields.needsAttachmentInfo(), sOptions);
    }

    @Override
    protected SearchIterator<Contact> doSearchContactsWithAnniversary(final Session session, final Date from, final Date until, List<String> folderIDs, ContactField[] fields, SortOptions sortOptions) throws OXException {
        int userID = session.getUserId();
        int contextID = session.getContextId();
        Map<ContactStorage, List<String>> queriedStorages = Tools.getStorages(session, null == folderIDs ? Tools.getVisibleFolders(contextID, userID) : folderIDs);
        Check.hasStorages(queriedStorages);
        final QueryFields queryFields = new QueryFields(fields);
        final SortOptions sOptions = null != sortOptions ? sortOptions : SortOptions.EMPTY;
        ArrayList<AbstractTask<SearchIterator<Contact>>> tasks2 = new ArrayList<AbstractTask<SearchIterator<Contact>>>(queriedStorages.size());
        for (final Map.Entry<ContactStorage, List<String>> queriedStorage : queriedStorages.entrySet()) {
            tasks2.add(new AbstractTask<SearchIterator<Contact>>(){

                public SearchIterator<Contact> call() throws Exception {
                    return ((ContactStorage)queriedStorage.getKey()).searchByAnniversary(session, (List)queriedStorage.getValue(), from, until, queryFields.getFields(), sOptions);
                }
            });
        }
        return ContactServiceImpl.perform(tasks2, session, queryFields.needsAttachmentInfo(), sOptions);
    }

    @Override
    protected int doCountContacts(Session session, String folderId) throws OXException {
        int contextId = session.getContextId();
        FolderObject folder = Tools.getFolder(contextId, folderId);
        Check.isContactFolder(folder, session);
        EffectivePermission permission = Tools.getPermission(session, folder);
        if (!permission.canReadOwnObjects()) {
            return 0;
        }
        ContactStorage storage = Tools.getStorage(session, folderId);
        return storage.count(session, folderId, permission.canReadAllObjects());
    }

    private static SearchIterator<Contact> perform(List<AbstractTask<SearchIterator<Contact>>> tasks2, Session session, boolean needsAttachmentInfo, SortOptions sortOptions) throws OXException {
        try {
            if (null == tasks2 || 0 == tasks2.size()) {
                List emptyList = Collections.emptyList();
                return new SearchIteratorAdapter(emptyList.iterator(), 0);
            }
            if (1 == tasks2.size()) {
                return new ResultIterator((SearchIterator<Contact>)((SearchIterator)tasks2.get(0).call()), needsAttachmentInfo, session);
            }
            ArrayList<SearchIterator<Contact>> searchIterators = new ArrayList<SearchIterator<Contact>>();
            ExecutorService executor = ContactServiceLookup.getService(ThreadPoolService.class).getExecutor();
            for (Future<SearchIterator<Contact>> future : executor.invokeAll(tasks2)) {
                searchIterators.add(new ResultIterator(future.get(), needsAttachmentInfo, session));
            }
            return new ContactMergerator(Tools.getComparator(sortOptions), searchIterators);
        }
        catch (Exception e) {
            if (null != e.getCause() && OXException.class.isInstance(e.getCause())) {
                throw (OXException)e.getCause();
            }
            throw ContactExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

